/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hexnowloading.dungeonnowloading.block.entity.PlayerStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLProcessors;
import dev.hexnowloading.dungeonnowloading.supporter.PatronRegistry;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class StatueProcessor
extends class_3491 {
    public static final Codec<StatueProcessor> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("campaign").forGetter(p -> p.campaign), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(p -> Float.valueOf(p.chance)), (App)class_7923.field_41175.method_39673().optionalFieldOf("fallback_block", (Object)class_2246.field_10124).forGetter(p -> p.fallbackBlock)).apply((Applicative)i, StatueProcessor::new));
    private final String campaign;
    private final float chance;
    private final class_2248 fallbackBlock;

    public StatueProcessor(String campaign) {
        this(campaign, 1.0f, class_2246.field_10124);
    }

    public StatueProcessor(String campaign, float chance, class_2248 fallbackBlock) {
        this.campaign = campaign;
        this.chance = Math.max(0.0f, Math.min(1.0f, chance));
        this.fallbackBlock = fallbackBlock == null ? class_2246.field_10124 : fallbackBlock;
    }

    public class_3499.class_3501 method_15110(class_4538 level, class_2338 pieceOrigin, class_2338 pieceWorldPos, class_3499.class_3501 original, class_3499.class_3501 current, class_3492 settings) {
        class_2487 beTag;
        if (!current.comp_1342().method_27852(DNLBlocks.PLAYER_STATUE.get())) {
            return current;
        }
        class_5819 rand = settings.method_15115(current.comp_1341());
        if (rand.method_43057() >= this.chance) {
            return new class_3499.class_3501(current.comp_1341(), this.fallbackBlock.method_9564(), null);
        }
        class_2680 state = current.comp_1342();
        class_2487 class_24872 = beTag = current.comp_1343() == null ? new class_2487() : current.comp_1343().method_10553();
        if (!beTag.method_10573("PoseVariant", 3)) {
            beTag.method_10569("PoseVariant", rand.method_43048(4));
        }
        beTag.method_10551("Owner");
        beTag.method_10551("SkullOwner");
        PatronRegistry.Patron patron = PatronRegistry.pickPatron(this.campaign, rand);
        if (patron != null && patron.uuid != null) {
            class_2487 owner = new class_2487();
            owner.method_25927("Id", patron.uuid);
            if (patron.name != null && !patron.name.isBlank()) {
                owner.method_10582("Name", patron.name);
            }
            beTag.method_10566("Owner", (class_2520)owner);
            PlayerStatueBlockEntity.NotchTier tier = PatronRegistry.tierFor(patron);
            beTag.method_10582("NotchTier", tier.name());
        } else {
            beTag.method_10582("NotchTier", PlayerStatueBlockEntity.NotchTier.NONE.name());
        }
        return new class_3499.class_3501(current.comp_1341(), state, beTag);
    }

    protected class_3828<?> method_16772() {
        return DNLProcessors.STATUE_PROCESSOR.get();
    }
}

