/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures;

import com.mojang.logging.LogUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.trashelemental.floral_tonics_and_tinctures.Config;
import net.trashelemental.floral_tonics_and_tinctures.block.ModBlocks;
import net.trashelemental.floral_tonics_and_tinctures.entity.ModEntities;
import net.trashelemental.floral_tonics_and_tinctures.item.ModCreativeModeTabs;
import net.trashelemental.floral_tonics_and_tinctures.item.ModItems;
import net.trashelemental.floral_tonics_and_tinctures.magic.brewing.ModPotions;
import net.trashelemental.floral_tonics_and_tinctures.magic.effects.ModMobEffects;
import net.trashelemental.floral_tonics_and_tinctures.magic.enchantments.ModEnchantments;
import net.trashelemental.floral_tonics_and_tinctures.menu.ModMenuTypes;
import net.trashelemental.floral_tonics_and_tinctures.menu.custom.HerbalismTableScreen;
import net.trashelemental.floral_tonics_and_tinctures.menu.custom.herbalism_kit.HerbalismKitScreen;
import net.trashelemental.floral_tonics_and_tinctures.particle.ModParticles;
import net.trashelemental.floral_tonics_and_tinctures.util.ModItemProperties;
import net.trashelemental.floral_tonics_and_tinctures.util.recipe.ModRecipeTypes;
import net.trashelemental.floral_tonics_and_tinctures.util.recipe.ModRecipes;
import org.slf4j.Logger;

@Mod(value="floral_tonics_and_tinctures")
public class FloralTonicsAndTinctures {
    public static final String MOD_ID = "floral_tonics_and_tinctures";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public FloralTonicsAndTinctures() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModEntities.register(modEventBus);
        ModPotions.register(modEventBus);
        ModMobEffects.register(modEventBus);
        ModEnchantments.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.SERIALIZERS.register(modEventBus);
        ModRecipeTypes.TYPES.register(modEventBus);
        ModParticles.PARTICLES.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.FIRE_LILY.getId(), ModBlocks.POTTED_FIRE_LILY);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.HEATHER.getId(), ModBlocks.POTTED_HEATHER);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.MILKWEED.getId(), ModBlocks.POTTED_MILKWEED);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.MOLY.getId(), ModBlocks.POTTED_MOLY);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.LAVADROP.getId(), ModBlocks.POTTED_LAVADROP);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.MIDAS_FINGERS.getId(), ModBlocks.POTTED_MIDAS_FINGERS);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.STELLA.getId(), ModBlocks.POTTED_STELLA);
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() != ModCreativeModeTabs.FLORAL_TONICS_AND_TINCTURES_TAB.get()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        RecipeManager manager = mc.m_91403_().m_105141_();
        manager.m_44013_((RecipeType)ModRecipeTypes.HERBALISM.get()).forEach(r -> {
            ItemStack output = r.getResultItem();
            if (output.m_41720_() == ModItems.TONIC.get()) {
                event.m_246342_(output);
            }
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static void queueServerWork(int tickDelay, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tickDelay));
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actionsToRun = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() <= 0) {
                    actionsToRun.add(work);
                }
            });
            actionsToRun.forEach(work -> ((Runnable)work.getKey()).run());
            workQueue.removeAll(actionsToRun);
        }
    }

    @Mod.EventBusSubscriber(modid="floral_tonics_and_tinctures", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModItemProperties.registerCustomItemProperties();
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.HERBALISM_TABLE.get()), HerbalismTableScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.HERBALISM_KIT.get()), HerbalismKitScreen::new);
        }
    }
}

