/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures.magic.effects.event;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.trashelemental.floral_tonics_and_tinctures.junkyard_lib.visual.particle.ParticleMethods;
import net.trashelemental.floral_tonics_and_tinctures.magic.effects.ModMobEffects;

@Mod.EventBusSubscriber
public class FieryEffectEvents {
    private static final Map<UUID, Map<InteractionHand, SmeltProgress>> progressMap = new HashMap<UUID, Map<InteractionHand, SmeltProgress>>();
    private static final int SMELT_TIME = 60;

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        LivingEntity entity;
        boolean targetHasFiery = false;
        boolean attackerHasFiery = false;
        int minBurnSeconds = 4;
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        MobEffect fiery = (MobEffect)ModMobEffects.FIERY.get();
        if (attacker == null) {
            return;
        }
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (target.m_21023_(fiery)) {
            targetHasFiery = true;
        }
        if (attacker instanceof LivingEntity && (entity = (LivingEntity)attacker).m_21023_(fiery)) {
            attackerHasFiery = true;
        }
        if (!targetHasFiery && !attackerHasFiery) {
            return;
        }
        if (targetHasFiery) {
            int fieryLevel = target.m_21124_(fiery).m_19564_();
            attacker.m_20254_(minBurnSeconds + fieryLevel);
        }
        if (attackerHasFiery) {
            int fieryLevel = ((LivingEntity)attacker).m_21124_(fiery).m_19564_();
            target.m_20254_(minBurnSeconds + fieryLevel);
        }
    }

    public static void smeltItems(Player player) {
        UUID id = player.m_20148_();
        Map handMap = progressMap.computeIfAbsent(id, k -> new EnumMap(InteractionHand.class));
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() || stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof ArmorItem) {
                handMap.remove(hand);
                continue;
            }
            ItemStack result = FieryEffectEvents.getSmeltingResult(player, stack);
            if (result.m_41619_()) {
                handMap.remove(hand);
                continue;
            }
            SmeltProgress progress = (SmeltProgress)handMap.get(hand);
            if (progress == null || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)progress.stack)) {
                progress = new SmeltProgress(stack.m_41777_(), 0);
                handMap.put(hand, progress);
                ParticleMethods.ParticlesAroundServerSide(player.m_9236_(), (ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20188_() - 0.3, player.m_20189_(), 5, 1.5);
                continue;
            }
            ++progress.ticks;
            if (progress.ticks < 60) continue;
            FieryEffectEvents.smeltItem(player, hand, stack, result);
            handMap.remove(hand);
        }
    }

    private static ItemStack getSmeltingResult(Player player, ItemStack stack) {
        RecipeManager recipeManager = player.m_9236_().m_7465_();
        return recipeManager.m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack.m_255036_(1)}), player.m_9236_()).map(recipe -> recipe.m_8043_(player.m_9236_().m_9598_()).m_41777_()).orElse(ItemStack.f_41583_);
    }

    private static void smeltItem(Player player, InteractionHand hand, ItemStack input, ItemStack output) {
        input.m_41774_(1);
        if (input.m_41619_()) {
            player.m_21008_(hand, output);
        } else if (!player.m_36356_(output)) {
            player.m_36176_(output, false);
        }
        ParticleMethods.ParticlesAroundServerSide(player.m_9236_(), (ParticleOptions)ParticleTypes.f_123744_, player.m_20185_(), player.m_20188_() - 0.3, player.m_20189_(), 5, 1.5);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11784_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private static class SmeltProgress {
        final ItemStack stack;
        int ticks;

        SmeltProgress(ItemStack stack, int ticks) {
            this.stack = stack;
            this.ticks = ticks;
        }
    }
}

