/*
 * Decompiled with CFR 0.152.
 */
package net.trashelemental.floral_tonics_and_tinctures.magic.effects.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.trashelemental.floral_tonics_and_tinctures.magic.effects.ModMobEffects;

@Mod.EventBusSubscriber
public class GoldRushEffectEvents {
    private static final RandomSource random = RandomSource.m_216327_();

    @SubscribeEvent
    public static void onArmorDamaged(LivingHurtEvent event) {
        MobEffect effect;
        LivingEntity entity = event.getEntity();
        if (!entity.m_21023_(effect = (MobEffect)ModMobEffects.GOLD_RUSH.get())) {
            return;
        }
        if (entity.m_9236_().f_46443_) {
            return;
        }
        int amplifier = entity.m_21124_(effect).m_19564_();
        for (ItemStack armor : entity.m_6168_()) {
            ArmorItem ai;
            Item item = armor.m_41720_();
            if (!(item instanceof ArmorItem) || (ai = (ArmorItem)item).m_40401_() != ArmorMaterials.GOLD) continue;
            GoldRushEffectEvents.slowDurabilityLoss(armor, entity, amplifier);
        }
    }

    @SubscribeEvent
    public static void onToolUse(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        MobEffect effect = (MobEffect)ModMobEffects.GOLD_RUSH.get();
        if (!player.m_21023_(effect)) {
            return;
        }
        if (player.m_9236_().f_46443_) {
            return;
        }
        int amplifier = player.m_21124_(effect).m_19564_();
        ItemStack tool = player.m_21205_();
        if (tool.m_204117_(ItemTags.f_13151_)) {
            GoldRushEffectEvents.slowDurabilityLoss(tool, (LivingEntity)player, amplifier);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        int amplifier;
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        MobEffect effect = (MobEffect)ModMobEffects.GOLD_RUSH.get();
        if (!target.m_21023_(effect) && !attacker.m_21023_(effect)) {
            return;
        }
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (target.m_21023_(effect)) {
            amplifier = target.m_21124_(effect).m_19564_();
            boolean hasGoldArmor = false;
            for (ItemStack armor : target.m_6168_()) {
                ArmorItem ai;
                Item item = armor.m_41720_();
                if (!(item instanceof ArmorItem) || (ai = (ArmorItem)item).m_40401_() != ArmorMaterials.GOLD) continue;
                hasGoldArmor = true;
                break;
            }
            if (hasGoldArmor) {
                float reduction = 0.8f - 0.1f * (float)amplifier;
                reduction = Math.max(0.0f, reduction);
                event.setAmount(event.getAmount() * reduction);
            }
        }
        if (attacker.m_21023_(effect)) {
            amplifier = attacker.m_21124_(effect).m_19564_();
            boolean hasGoldTool = false;
            ItemStack tool = attacker.m_21205_();
            if (tool.m_204117_(ItemTags.f_13151_)) {
                hasGoldTool = true;
            }
            if (hasGoldTool) {
                float increase = 1.5f + 0.25f * (float)amplifier;
                event.setAmount(event.getAmount() * increase);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        MobEffect effect = (MobEffect)ModMobEffects.GOLD_RUSH.get();
        if (!player.m_21023_(effect)) {
            return;
        }
        if (player.m_9236_().f_46443_) {
            return;
        }
        int amplifier = player.m_21124_(effect).m_19564_();
        ItemStack tool = player.m_21205_();
        if (!tool.m_204117_(ItemTags.f_13151_)) {
            return;
        }
        BlockState state = event.getState();
        GoldRushEffectEvents.slowDurabilityLoss(tool, (LivingEntity)player, amplifier);
        if (!state.m_204336_(Tags.Blocks.ORES)) {
            return;
        }
        if (random.m_188501_() < 0.33f) {
            int multiplier = 2 * (1 + amplifier);
            Level world = player.m_9236_();
            if (!(world instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverWorld = (ServerLevel)world;
            BlockPos pos = event.getPos();
            LootParams.Builder paramsBuilder = new LootParams.Builder(serverWorld).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)tool).m_287289_(LootContextParams.f_81462_, (Object)world.m_7702_(pos));
            for (int i = 0; i < multiplier; ++i) {
                List drops = state.m_287290_(paramsBuilder);
                for (ItemStack drop : drops) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onKilledEntity(LivingDeathEvent event) {
        ItemStack weapon;
        Entity attackerEntity = event.getSource().m_7639_();
        if (!(attackerEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)attackerEntity;
        MobEffect effect = (MobEffect)ModMobEffects.GOLD_RUSH.get();
        if (!attacker.m_21023_(effect)) {
            return;
        }
        int amplifier = attacker.m_21124_(effect).m_19564_();
        RandomSource random = attacker.m_217043_();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            v0 = player.m_21205_();
        } else {
            v0 = weapon = ItemStack.f_41583_;
        }
        if (!weapon.m_204117_(ItemTags.f_13151_)) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (random.m_188501_() >= 0.33f) {
            return;
        }
        int multiplier = 2 * (1 + amplifier);
        ServerLevel serverLevel = (ServerLevel)attacker.m_9236_();
        for (int i = 0; i < multiplier; ++i) {
            ResourceLocation lootTableKey = target.m_5743_();
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableKey);
            LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)target).m_287286_(LootContextParams.f_81460_, (Object)target.m_20182_()).m_287286_(LootContextParams.f_81458_, (Object)attacker).m_287289_(LootContextParams.f_81457_, (Object)event.getSource());
            LootParams lootParams = lootParamsBuilder.m_287235_(LootContextParamSets.f_81415_);
            lootTable.m_287276_(lootParams, target.m_287233_(), arg_0 -> ((LivingEntity)target).m_19983_(arg_0));
        }
    }

    private static void slowDurabilityLoss(ItemStack itemStack, LivingEntity entity, int amplifier) {
        RandomSource random = entity.m_217043_();
        if ((double)random.m_188501_() < 0.5 + 0.15 * (double)(amplifier + 1)) {
            int currentDamage = itemStack.m_41773_();
            itemStack.m_41721_(Math.max(0, currentDamage - 1));
        }
    }
}

