/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.mining_quakes.particle;

import com.gaura.mining_quakes.particle.BlockQuakeParticle;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_703;

public class BlockQuakeParticleManager {
    private static final Map<class_2338, BlockQuakeParticle> BLOCK_QUAKE_PARTICLES = new HashMap<class_2338, BlockQuakeParticle>();
    private static final Set<class_2338> INVISIBLE_BLOCKS = new CopyOnWriteArraySet<class_2338>();

    public static void addQuakeAnimation(class_638 clientLevel, class_2338 blockPos, class_2680 blockState, class_2350 direction, int randomHorizontal, int randomVertical) {
        BlockQuakeParticle blockQuakeParticle = new BlockQuakeParticle(clientLevel, blockPos, blockState, direction, randomHorizontal, randomVertical);
        BlockQuakeParticle previousBlockQuakeParticle = BLOCK_QUAKE_PARTICLES.put(blockPos, blockQuakeParticle);
        if (previousBlockQuakeParticle != null && previousBlockQuakeParticle.method_3086()) {
            previousBlockQuakeParticle.method_3085();
        }
        class_310.method_1551().field_1713.method_3058((class_703)blockQuakeParticle);
        BlockQuakeParticleManager.setBlockInvisible(clientLevel, blockPos, blockState);
    }

    public static void addQuake(class_2338 blockPos, class_4587 poseStack, float f) {
        BlockQuakeParticle blockQuakeParticle = BLOCK_QUAKE_PARTICLES.get(blockPos);
        if (blockQuakeParticle != null && blockQuakeParticle.method_3086()) {
            blockQuakeParticle.animate(poseStack, f);
        }
    }

    public static void removeQuakeAnimation(class_638 clientLevel, class_2338 blockPos, class_2680 blockState) {
        BlockQuakeParticle blockQuakeParticle = BLOCK_QUAKE_PARTICLES.remove(blockPos);
        if (blockQuakeParticle != null && blockQuakeParticle.method_3086()) {
            blockQuakeParticle.method_3085();
        }
        BlockQuakeParticleManager.setBlockVisible(clientLevel, blockPos, blockState);
    }

    public static void setBlockInvisible(class_638 clientLevel, class_2338 blockPos, class_2680 blockState) {
        if (INVISIBLE_BLOCKS.add(blockPos)) {
            BlockQuakeParticleManager.updateBlock(clientLevel, blockPos, blockState);
        }
    }

    public static void setBlockVisible(class_638 clientLevel, class_2338 blockPos, class_2680 blockState) {
        if (INVISIBLE_BLOCKS.remove(blockPos)) {
            BlockQuakeParticleManager.updateBlock(clientLevel, blockPos, blockState);
        }
    }

    public static boolean isBlockInvisible(class_2338 blockPos) {
        return INVISIBLE_BLOCKS.contains(blockPos);
    }

    private static void updateBlock(class_638 clientLevel, class_2338 blockPos, class_2680 blockState) {
        clientLevel.method_8413(blockPos, blockState, blockState, 2);
    }
}

