/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.mining_quakes.particle;

import com.gaura.mining_quakes.MiningQuakes;
import com.gaura.mining_quakes.mixin.ClientLevelAccessor;
import com.gaura.mining_quakes.mixin.LevelRendererAccessor;
import com.gaura.mining_quakes.particle.BlockQuakeParticleManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class BlockQuakeParticle
extends Particle {
    private final BlockPos blockPos;
    private final BlockState blockState;
    private final Direction direction;
    private final List<BlockModelPart> blockModelParts;
    private final ModelBlockRenderer modelBlockRenderer;
    private Vec3 pivotPoint;
    private final int randomHorizontal;
    private final int randomVertical;
    static final Map<Direction, RotationPair> ROTATIONS = Map.of(Direction.SOUTH, new RotationPair(Axis.ZP, Axis.YP), Direction.NORTH, new RotationPair(Axis.ZN, Axis.YP), Direction.EAST, new RotationPair(Axis.XP, Axis.YP), Direction.WEST, new RotationPair(Axis.XN, Axis.YP), Direction.DOWN, new RotationPair(Axis.XP, Axis.ZP), Direction.UP, new RotationPair(Axis.XN, Axis.ZP));

    public BlockQuakeParticle(ClientLevel clientLevel, BlockPos blockPos, BlockState blockState, Direction direction, int randomHorizontal, int randomVertical) {
        super(clientLevel, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        this.age = 0;
        this.lifetime = MiningQuakes.CONFIG.lifetime;
        this.hasPhysics = false;
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.direction = direction;
        RandomSource randomSource = RandomSource.create((long)this.blockState.getSeed(this.blockPos));
        this.blockModelParts = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState).collectParts(randomSource);
        this.modelBlockRenderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
        this.pivotPoint = new Vec3(0.5, 0.5, 0.5);
        if (blockState.getBlock() instanceof DoorBlock) {
            this.pivotPoint = this.pivotPoint.relative(((DoubleBlockHalf)blockState.getValue((Property)DoorBlock.HALF)).getDirectionToOther(), 0.5);
        } else if (blockState.getBlock() instanceof ChestBlock && blockState.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            this.pivotPoint = this.pivotPoint.relative(ChestBlock.getConnectedDirection((BlockState)blockState), 0.5);
        } else if (blockState.getBlock() instanceof BedBlock) {
            this.pivotPoint = this.pivotPoint.relative(BedBlock.getConnectedDirection((BlockState)blockState), 0.5);
        }
        this.randomHorizontal = randomHorizontal;
        this.randomVertical = randomVertical;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age == this.lifetime) {
            BlockQuakeParticleManager.setBlockVisible(this.level, this.blockPos, this.blockState);
        } else if (this.age > this.lifetime) {
            this.remove();
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
    }

    public void renderCustom(PoseStack poseStack, MultiBufferSource multiBufferSource, Camera camera, float f) {
        poseStack.pushPose();
        float x = (float)(Mth.lerp((double)f, (double)this.xo, (double)this.x) - camera.getPosition().x());
        float y = (float)(Mth.lerp((double)f, (double)this.yo, (double)this.y) - camera.getPosition().y());
        float z = (float)(Mth.lerp((double)f, (double)this.zo, (double)this.z) - camera.getPosition().z());
        poseStack.translate(x, y, z);
        this.animate(poseStack, f);
        this.modelBlockRenderer.tesselateBlock((BlockAndTintGetter)this.level, this.blockModelParts, this.blockState, this.blockPos, poseStack, multiBufferSource.getBuffer(ItemBlockRenderTypes.getMovingBlockRenderType((BlockState)this.blockState)), false, OverlayTexture.NO_OVERLAY);
        Long2ObjectMap<SortedSet<BlockDestructionProgress>> destructionProgress = ((LevelRendererAccessor)((ClientLevelAccessor)this.level).getLevelRenderer()).getDestructionProgress();
        SortedSet progressSet = (SortedSet)destructionProgress.get(this.blockPos.asLong());
        if (progressSet != null && !progressSet.isEmpty()) {
            this.modelBlockRenderer.tesselateBlock((BlockAndTintGetter)this.level, this.blockModelParts, this.blockState, this.blockPos, poseStack, (VertexConsumer)new SheetedDecalTextureGenerator(multiBufferSource.getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(((BlockDestructionProgress)progressSet.last()).getProgress())), poseStack.last(), 1.0f), true, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
    }

    public void animate(PoseStack poseStack, float f) {
        float t = ((float)this.age + f) / (float)this.lifetime;
        float horizontalOscillations = (float)Math.sin((double)MiningQuakes.CONFIG.horizontalOscillations * Math.PI * (double)t);
        float verticalOscillations = (float)Math.sin((double)MiningQuakes.CONFIG.verticalOscillations * Math.PI * (double)t);
        float decay = MiningQuakes.CONFIG.easingFunction.apply(t);
        float horizontalAngle = MiningQuakes.CONFIG.horizontalMaxAngle * horizontalOscillations * decay;
        float verticalAngle = MiningQuakes.CONFIG.verticalMaxAngle * verticalOscillations * decay;
        if (MiningQuakes.CONFIG.randomQuakes) {
            horizontalAngle *= (float)this.randomHorizontal;
            verticalAngle *= (float)this.randomVertical;
        }
        RotationPair rotation = ROTATIONS.get(this.direction);
        poseStack.translate(this.pivotPoint);
        poseStack.mulPose((Quaternionfc)rotation.horizontalAxis.rotationDegrees(verticalAngle));
        poseStack.mulPose((Quaternionfc)rotation.verticalAxis.rotationDegrees(horizontalAngle));
        poseStack.translate(this.pivotPoint.reverse());
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    record RotationPair(Axis horizontalAxis, Axis verticalAxis) {
    }
}

