/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.reaper.ancientnature.AncientNature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ANLogger {
    private static final Logger LOGGER = LogManager.getLogger((String)AncientNature.class.getName());
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final ExecutorService LOG_EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "ANLogger-Thread");
        t.setDaemon(true);
        return t;
    });

    public static void log(@NotNull Color color, @NotNull String message, Object ... args) {
        LOG_EXECUTOR.submit(() -> {
            String formatted = args.length > 0 ? String.format(message, args) : message;
            String timestamp = LocalDateTime.now().format(TIME_FORMAT);
            String logMessage = String.format("%s[%s] %s%s", color.getCode(), timestamp, formatted, Color.RESET.getCode());
            LOGGER.info(logMessage);
        });
    }

    public static enum Color {
        RESET("\u001b[0m"),
        RED("\u001b[31m"),
        GREEN("\u001b[32m"),
        YELLOW("\u001b[33m"),
        CYAN("\u001b[36m");

        private final String code;

        private Color(String code) {
            this.code = code;
        }

        @NotNull
        public String getCode() {
            return this.code;
        }
    }
}

