/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import net.reaper.ancientnature.api.io.network.NetworkCreator;
import net.reaper.ancientnature.client.model.ANLayers;
import net.reaper.ancientnature.common.enchantment.ANEnchantments;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.MobDietRegistry;
import net.reaper.ancientnature.common.event.CameraShakeManager;
import net.reaper.ancientnature.common.item.GeologistHammerItem;
import net.reaper.ancientnature.common.worldgen.tree.ANFoliagePlacerTypes;
import net.reaper.ancientnature.common.worldgen.tree.ANTrunkPlacerTypes;
import net.reaper.ancientnature.core.config.AncientNatureConfig;
import net.reaper.ancientnature.core.proxy.ANClientProxy;
import net.reaper.ancientnature.core.proxy.ANCommonProxy;
import net.reaper.ancientnature.core.registry.ANAdvancementsRegistry;
import net.reaper.ancientnature.core.registry.ANBlockEntities;
import net.reaper.ancientnature.core.registry.ANBlocks;
import net.reaper.ancientnature.core.registry.ANCreativeTabs;
import net.reaper.ancientnature.core.registry.ANDecoratedPotsPatterns;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANEntityData;
import net.reaper.ancientnature.core.registry.ANGameEvents;
import net.reaper.ancientnature.core.registry.ANGuiElements;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.core.registry.ANLootModifiers;
import net.reaper.ancientnature.core.registry.ANMenus;
import net.reaper.ancientnature.core.registry.ANMobEffects;
import net.reaper.ancientnature.core.registry.ANParticles;
import net.reaper.ancientnature.core.registry.ANRecipes;
import net.reaper.ancientnature.core.registry.ANSounds;
import net.reaper.ancientnature.core.util.ANWoodTypes;
import net.reaper.ancientnature.io.network.packet.AnimationSyncPacket;
import net.reaper.ancientnature.io.network.packet.PlayerInputPacket;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="ancientnature")
public class AncientNature {
    public static final String MOD_ID = "ancientnature";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static ANCommonProxy PROXY = (ANCommonProxy)DistExecutor.safeRunForDist(() -> ANClientProxy::new, () -> ANCommonProxy::new);
    public static final NetworkCreator NETWORK = NetworkCreator.create("ancientnature", 1);

    public AncientNature() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AncientNatureConfig.SPEC);
        ANCreativeTabs.register(bus);
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(ANLayers.ANEntityLayers::onRegisterLayerDefinitions);
        ANItems.ITEMS.register(bus);
        ANBlocks.BLOCKS.register(bus);
        ANSounds.SOUND_EVENTS.register(bus);
        ANEntities.ENTITY_TYPES.register(bus);
        ANBlockEntities.TES.register(bus);
        ANDecoratedPotsPatterns.DECORATED_POTS_PATTERNS.register(bus);
        ANMobEffects.MOB_EFFECTS.register(bus);
        ANTrunkPlacerTypes.TRUNK_PLACERS.register(bus);
        ANFoliagePlacerTypes.FOLIAGE_PLACERS.register(bus);
        ANRecipes.RECIPE_TYPES.register(bus);
        ANRecipes.RECIPE_SERIALIZERS.register(bus);
        ANParticles.PARTICLES.register(bus);
        ANMenus.MENUS.register(bus);
        ANEntityData.DATA.register(bus);
        ANLootModifiers.LOOT_MODIFIERS.register(bus);
        ANGameEvents.GAME_EVENTS.register(bus);
        bus.addListener(this::addCreative);
        CameraShakeManager.init();
        ANGuiElements.init();
        ANAdvancementsRegistry.setup();
        Sheets.addWoodType((WoodType)ANWoodTypes.GINKGO);
        Sheets.addWoodType((WoodType)ANWoodTypes.LEPIDODENDRON);
        PROXY.commonInit();
        ANEnchantments.register(bus);
    }

    private void onCommonSetup(@NotNull FMLCommonSetupEvent event) {
        MobDietRegistry.init();
        NETWORK.regPacket(AnimationSyncPacket.class).regPacket(PlayerInputPacket.class);
        event.enqueueWork(() -> {
            ANDecoratedPotsPatterns.addDecoratedPotsPatterns();
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ANBlocks.GINKGO_SAPLING.getId(), ANBlocks.POTTED_GINKGO_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ANBlocks.LEPIDODENDRON_SAPLING.getId(), ANBlocks.POTTED_LEPIDODENDRON_SAPLING);
        });
    }

    private void onClientSetup(@NotNull FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            PROXY.clientInit();
            Minecraft.m_91087_().m_91385_().enableStencil();
            ItemProperties.register((Item)((Item)ANItems.GEOLOGIST_HAMMER.get()), (ResourceLocation)new ResourceLocation(MOD_ID, "efficient"), (stack, level, entity, seed) -> {
                Item patt5919$temp = stack.m_41720_();
                if (patt5919$temp instanceof GeologistHammerItem) {
                    GeologistHammerItem hammer = (GeologistHammerItem)patt5919$temp;
                    return hammer.isEfficient(stack) ? 1.0f : 0.0f;
                }
                return 0.0f;
            });
        });
    }

    public static ResourceLocation modLoc(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static ResourceLocation entityTexture(String name) {
        return AncientNature.modLoc("textures/entity/" + name);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256750_) {
            List<Item> items = ANItems.ITEMS.getEntries().stream().map(RegistryObject::get).toList();
            for (Item item : items) {
                event.m_246326_((ItemLike)item);
            }
        }
    }
}

