/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.client;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class TooltipColors {
    public static final TooltipColors INSTANCE = new TooltipColors();
    private final Map<Item, Style> colors = new HashMap<Item, Style>();

    private TooltipColors() {
    }

    @NotNull
    public TooltipColors register(@NotNull Item item, @NotNull Style style) {
        this.colors.put(item, style);
        return this;
    }

    public Map<Item, Style> getColors() {
        return this.colors;
    }

    @Mod.EventBusSubscriber(modid="ancientnature", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void onRenderTooltipColor(@NotNull RenderTooltipEvent.Color event) {
            Style style = TooltipColors.INSTANCE.colors.get(event.getItemStack().m_41720_());
            if (style != null) {
                event.setBackground(style.getBackground());
                event.setBorderStart(style.getBorderStart());
                event.setBorderEnd(style.getBorderEnd());
            }
        }
    }

    public static abstract class Style {
        private static final Map<Integer, Integer> COLOR_CACHE = new HashMap<Integer, Integer>();

        public abstract int getBackground();

        public abstract int getBorderStart();

        public abstract int getBorderEnd();

        public int color(@NotNull Color color) {
            return COLOR_CACHE.computeIfAbsent(color.getRGB(), key -> color.getRGB());
        }
    }
}

