/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.client.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.core.config.AncientNatureConfig;
import net.reaper.ancientnature.core.registry.ANEntities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class DynamicCamera {
    public static final DynamicCamera INSTANCE = new DynamicCamera();
    public static float currentRoll = 0.0f;
    public static float targetRoll = 0.0f;
    private final List<RollData> rolls = new ArrayList<RollData>();

    public DynamicCamera addCameraRoll(RollData data) {
        this.rolls.add(data);
        return this;
    }

    @Nullable
    public RollData get(EntityType<?> entityType) {
        for (RollData data : this.rolls) {
            if (data.entityType != entityType) continue;
            return data;
        }
        return null;
    }

    public static void initAll() {
        INSTANCE.addCameraRoll(new RollData((EntityType)ANEntities.PARANOGMIUS.get(), 65.0f, 11.0f));
    }

    public record RollData(EntityType<?> entityType, float maxAngle, float power) {
    }

    @Mod.EventBusSubscriber(modid="ancientnature", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void onComputeCameraAngles(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ViewportEvent.ComputeCameraAngles event) {
            Entity entity;
            Player player;
            if (!((Boolean)AncientNatureConfig.CAMERATILT.get()).booleanValue() || Minecraft.m_91087_().m_91104_()) {
                return;
            }
            Camera cam = event.getCamera();
            float roll = event.getRoll();
            Entity entity2 = cam.m_90592_();
            if (entity2 instanceof Player && (player = (Player)entity2).m_20159_() && (entity = player.m_20201_()) instanceof Mob) {
                Mob mob = (Mob)entity;
                RollData data = INSTANCE.get(mob.m_6095_());
                if (data != null) {
                    targetRoll = Math.max(-data.maxAngle, Math.min(data.maxAngle, (mob.f_19859_ - mob.m_146908_()) * data.power));
                    currentRoll += (targetRoll - currentRoll) * 0.1f;
                    event.setRoll(roll + currentRoll);
                } else {
                    currentRoll += (0.0f - currentRoll) * 0.07f;
                    event.setRoll(roll + currentRoll);
                }
            }
        }
    }
}

