/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.client.postprocessing;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.ancientnature.api.client.postprocessing.PostEffect;
import net.reaper.ancientnature.api.client.postprocessing.PostProcessor;
import net.reaper.ancientnature.api.client.postprocessing.effect.AnomalousEffectFilter;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PostEffectManager {
    private static final PostEffectManager instance = new PostEffectManager();
    private final CopyOnWriteArrayList<PostEffect> effects = new CopyOnWriteArrayList();
    private final PostProcessor postProcessor = PostProcessor.getInstance();
    private final Map<PostEffect, Boolean> effectStates = new HashMap<PostEffect, Boolean>();

    public static PostEffectManager getInstance() {
        return instance;
    }

    public void registerEffect(PostEffect effect) {
        this.effects.add(effect);
        this.postProcessor.register(effect.getPostShader());
        this.effectStates.put(effect, false);
    }

    public static void initAll() {
        PostEffectManager postManager = PostEffectManager.getInstance();
        postManager.registerEffect(new AnomalousEffectFilter());
    }

    public void applyEffects(@NotNull Player player) {
        for (PostEffect effect : this.effects) {
            ResourceLocation shader = effect.getPostShader();
            boolean isEffectActive = effect.canUse(player);
            Pair<PostChain, RenderTarget> pair = this.postProcessor.postEffects.get(shader);
            if (pair == null) continue;
            PostChain postChain = (PostChain)pair.getFirst();
            if (isEffectActive && !this.effectStates.get(effect).booleanValue()) {
                this.effectStates.put(effect, true);
            } else if (!isEffectActive && this.effectStates.get(effect).booleanValue()) {
                effect.onEffectStop(postChain);
                this.effectStates.put(effect, false);
            }
            if (!isEffectActive) continue;
            this.postProcessor.applyEffect(postChain);
            effect.renderTick(postChain, player);
        }
    }
}

