/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.client.postprocessing;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.mixin.accessor.EffectInstanceAccessor;
import net.reaper.ancientnature.mixin.accessor.PostChainAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PostProcessor {
    private static final Logger LOGGER = LogManager.getLogger(PostProcessor.class);
    private static final PostProcessor instance = new PostProcessor();
    private final List<ResourceLocation> registry = new ArrayList<ResourceLocation>();
    public final Map<ResourceLocation, Pair<PostChain, RenderTarget>> postEffects = new HashMap<ResourceLocation, Pair<PostChain, RenderTarget>>();
    public boolean loaded = false;
    private final Minecraft mc = Minecraft.m_91087_();
    private final RenderTarget mainTarget = this.mc.m_91385_();

    public PostProcessor register(ResourceLocation shader) {
        this.registry.add(shader);
        return this;
    }

    public void resize(int width, int height) {
        this.postEffects.values().forEach(pair -> {
            PostChain postChain = (PostChain)pair.getFirst();
            if (postChain != null) {
                try {
                    postChain.m_110025_(width, height);
                }
                catch (Exception exception) {
                    LOGGER.error("Error resizing post effect for width: {} and height: {}", (Object)width, (Object)height, (Object)exception);
                }
            }
        });
        for (Pair<PostChain, RenderTarget> pair2 : this.postEffects.values()) {
            RenderTarget target = (RenderTarget)pair2.getSecond();
            target.m_83941_(this.mainTarget.f_83915_, this.mainTarget.f_83916_, Minecraft.f_91002_);
        }
    }

    public void cleanup() {
        this.loaded = false;
        this.postEffects.values().forEach(pair -> {
            PostChain postChain = (PostChain)pair.getFirst();
            if (postChain != null) {
                try {
                    postChain.close();
                }
                catch (Exception exception) {
                    LOGGER.error("Error while closing post effect: ", (Throwable)exception);
                }
            }
        });
        this.postEffects.clear();
    }

    public void applyEffect(PostChain postChain) {
        try {
            postChain.m_110023_(this.mc.m_91296_());
        }
        catch (Exception exception) {
            LOGGER.error("Error while applying post effect: ", (Throwable)exception);
        }
    }

    @Nullable
    public Uniform getUniform(PostChain postChain, String uniformName) {
        try {
            for (PostPass pass : ((PostChainAccessor)postChain).getPasses()) {
                Uniform uniform = ((EffectInstanceAccessor)pass.m_110074_()).getUniforms().stream().filter(uniform1 -> uniform1.m_85599_().equals(uniformName)).findFirst().orElse(null);
                if (uniform == null) continue;
                return uniform;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error while retrieving uniform '{}'", (Object)uniformName, (Object)exception);
        }
        return null;
    }

    public void initialize() {
        this.cleanup();
        Window window = this.mc.m_91268_();
        for (ResourceLocation resource : this.registry) {
            TextureTarget renderTarget;
            PostChain postChain;
            try {
                postChain = new PostChain(this.mc.m_91097_(), this.mc.m_91098_(), this.mainTarget, resource);
                postChain.m_110025_(window.m_85441_(), window.m_85442_());
                renderTarget = new TextureTarget(window.m_85441_(), window.m_85442_(), true, Minecraft.f_91002_);
            }
            catch (Exception exception) {
                postChain = null;
                renderTarget = null;
                LOGGER.error("Failed to initialize post effect for resource: {}", (Object)resource, (Object)exception);
            }
            this.postEffects.put(resource, (Pair<PostChain, RenderTarget>)new Pair((Object)postChain, renderTarget));
        }
    }

    public static PostProcessor getInstance() {
        return instance;
    }

    public Map<ResourceLocation, Pair<PostChain, RenderTarget>> getPostEffects() {
        return this.postEffects;
    }

    public List<ResourceLocation> getRegistry() {
        return this.registry;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onAddReloadListener(@NotNull AddReloadListenerEvent event) {
            event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
                PostProcessor postProcessor = PostProcessor.getInstance();
                postProcessor.loaded = false;
                postProcessor.initialize();
            }));
        }
    }
}

