/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.client.renderer.armor;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.reaper.ancientnature.api.client.model.armor.AbstractArmorModel;
import net.reaper.ancientnature.api.client.renderer.armor.ArmorPart;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractArmorRenderer<T extends AbstractArmorModel> {
    protected final T model;
    private static final ModelPart EMPTY_PART = new ModelPart(Collections.emptyList(), Collections.emptyMap());
    private final Map<EquipmentSlot, HumanoidModel<?>> modelCache = new EnumMap(EquipmentSlot.class);

    public AbstractArmorRenderer(@NotNull Supplier<LayerDefinition> supplier, @NotNull Function<ModelPart, T> modelConstructor) {
        this.model = (AbstractArmorModel)((Object)modelConstructor.apply(supplier.get().m_171564_()));
    }

    public AbstractArmorRenderer<T> makeInvisible(boolean invisible) {
        ((AbstractArmorModel)((Object)this.model)).makeInvisible(invisible);
        return this;
    }

    public HumanoidModel<?> getOrCreateModel(@NotNull EquipmentSlot slot) {
        return this.modelCache.computeIfAbsent(slot, s -> new HumanoidModel(this.makeArmorParts((EquipmentSlot)s)));
    }

    public ModelPart makeArmorParts(@NotNull EquipmentSlot slot) {
        return new ModelPart(Collections.emptyList(), this.getArmorPartsMap(slot));
    }

    private @Unmodifiable @NotNull Map<String, ModelPart> getArmorPartsMap(@NotNull EquipmentSlot slot) {
        EnumMap<ArmorPart, ModelPart> parts = new EnumMap<ArmorPart, ModelPart>(ArmorPart.class);
        parts.put(ArmorPart.HEAD, this.getOrEmpty(slot == EquipmentSlot.HEAD ? ((AbstractArmorModel)((Object)this.model)).armorHead : null));
        parts.put(ArmorPart.HAT, EMPTY_PART);
        parts.put(ArmorPart.BODY, this.getOrEmpty(slot == EquipmentSlot.CHEST ? ((AbstractArmorModel)((Object)this.model)).armorChest : null));
        parts.put(ArmorPart.RIGHT_ARM, this.getOrEmpty(slot == EquipmentSlot.CHEST ? ((AbstractArmorModel)((Object)this.model)).armorRightArm : null));
        parts.put(ArmorPart.LEFT_ARM, this.getOrEmpty(slot == EquipmentSlot.CHEST ? ((AbstractArmorModel)((Object)this.model)).armorLeftArm : null));
        parts.put(ArmorPart.RIGHT_LEG, this.getOrEmpty(this.getLegPart(slot, true)));
        parts.put(ArmorPart.LEFT_LEG, this.getOrEmpty(this.getLegPart(slot, false)));
        return parts.entrySet().stream().collect(Collectors.toMap(entry -> ((ArmorPart)((Object)((Object)entry.getKey()))).name().toLowerCase(), Map.Entry::getValue));
    }

    @Contract(pure=true)
    @Nullable
    private ModelPart getLegPart(@NotNull EquipmentSlot slot, boolean isRightLeg) {
        switch (slot) {
            case FEET: {
                return isRightLeg ? ((AbstractArmorModel)((Object)this.model)).armorRightBoot : ((AbstractArmorModel)((Object)this.model)).armorLeftBoot;
            }
            case LEGS: {
                return isRightLeg ? ((AbstractArmorModel)((Object)this.model)).armorRightLeg : ((AbstractArmorModel)((Object)this.model)).armorLeftLeg;
            }
        }
        return null;
    }

    @NotNull
    private ModelPart getOrEmpty(@Nullable ModelPart part) {
        return part != null ? part : EMPTY_PART;
    }
}

