/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.client.screenshake;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.api.client.screenshake.ShakeData;
import net.reaper.ancientnature.core.config.AncientNatureConfig;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ScreenShaker {
    public static final ScreenShaker INSTANCE = new ScreenShaker();
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final int MAX_SHAKES = 50;
    private final List<ShakeData> shakes = new ArrayList<ShakeData>();

    public ScreenShaker addShake(@NotNull ShakeData data, boolean replaceAll) {
        if (replaceAll) {
            this.shakes.clear();
        }
        if (this.shakes.size() < 50) {
            this.shakes.add(data);
        }
        return this;
    }

    public void tick() {
        Iterator<ShakeData> iterator = this.shakes.iterator();
        while (iterator.hasNext()) {
            ShakeData data = iterator.next();
            if (data.ticks <= 0) {
                iterator.remove();
                continue;
            }
            --data.ticks;
        }
    }

    public float getShakeIntensity() {
        if (this.shakes.isEmpty()) {
            return 0.0f;
        }
        float totalIntensity = 0.0f;
        float maxIntensity = 0.0f;
        float randomOffset = 0.0f;
        for (ShakeData shake : this.shakes) {
            switch (shake.type) {
                case MULTIPLY: {
                    totalIntensity += shake.intensity;
                    break;
                }
                case NORMAL: {
                    maxIntensity = Math.max(maxIntensity, shake.intensity);
                    break;
                }
                case DECAY: {
                    float decayFactor = Math.max(0.1f, (float)shake.ticks / 20.0f);
                    maxIntensity = Math.max(maxIntensity, shake.intensity * decayFactor);
                    break;
                }
                case RANDOM: {
                    randomOffset += shake.intensity * (0.5f - RANDOM.m_188501_());
                }
            }
        }
        return totalIntensity + maxIntensity + randomOffset;
    }

    public List<ShakeData> getShakes() {
        return new ArrayList<ShakeData>(this.shakes);
    }

    @Mod.EventBusSubscriber(modid="ancientnature", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    private static class Events {
        private static final Minecraft mc = Minecraft.m_91087_();

        private Events() {
        }

        @SubscribeEvent
        public static void onClientTick(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull TickEvent.ClientTickEvent event) {
            if (!((Boolean)AncientNatureConfig.CAMERASHAKE.get()).booleanValue() || mc.m_91104_()) {
                return;
            }
            if (event.phase == TickEvent.Phase.START && !mc.m_91104_()) {
                INSTANCE.tick();
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onComputeCameraAngles(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ViewportEvent.ComputeCameraAngles event) {
            float intensity;
            if (!((Boolean)AncientNatureConfig.CAMERASHAKE.get()).booleanValue() || mc.m_91104_()) {
                return;
            }
            LocalPlayer player = Events.mc.f_91074_;
            Camera camera = event.getCamera();
            if (player != null && (intensity = (float)((double)INSTANCE.getShakeIntensity() * (Double)Events.mc.f_91066_.m_231924_().m_231551_())) > 0.0f) {
                RandomSource rand = player.m_217043_();
                double offsetX = (double)intensity * Math.sin((double)player.f_19797_ * 0.3 + rand.m_188500_() * Math.PI);
                double offsetY = (double)intensity * Math.cos((double)player.f_19797_ * 0.4 + rand.m_188500_() * Math.PI);
                double offsetZ = (double)intensity * Math.sin((double)player.f_19797_ * 0.2 + rand.m_188500_() * Math.PI * 0.5);
                camera.m_90568_(offsetX, offsetY, offsetZ);
            }
        }
    }
}

