/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.client.soundfilter.registry;

import net.reaper.ancientnature.api.client.soundfilter.registry.Filter;
import net.reaper.ancientnature.api.client.soundfilter.registry.FilterParams;
import org.jline.utils.Log;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.EXTEfx;

public abstract class AbstractSoundFilter
implements Filter {
    protected final int filterType;

    public AbstractSoundFilter(int filterType) {
        this.filterType = filterType;
    }

    protected int createFilter() {
        int filter = EXTEfx.alGenFilters();
        if (filter == 0) {
            Log.error((Object[])new Object[]{"Failed to generate OpenAL filter"});
        }
        return filter;
    }

    @Override
    public void apply(int source, FilterParams params) {
        if (this.filterType == 0) {
            AL10.alSourcei((int)source, (int)131077, (int)0);
            Log.debug((Object[])new Object[]{"Removed filter from source {}", source});
            return;
        }
        int filter = this.createFilter();
        try {
            EXTEfx.alFilteri((int)filter, (int)32769, (int)this.filterType);
            this.applyFilterParams(filter, params);
            AL10.alSourcei((int)source, (int)131077, (int)filter);
        }
        catch (Exception exception) {
            Log.error((Object[])new Object[]{"Error applying filter {} to source {}: {}", this.getClass().getSimpleName(), source, exception.getMessage(), exception});
        }
    }

    protected abstract void applyFilterParams(int var1, FilterParams var2);
}

