/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.client.soundfilter.registry;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FilterParams {
    private final float gain;
    private final float gainLF;
    private final float gainHF;

    @Contract(pure=true)
    private FilterParams(@NotNull Builder builder) {
        this.gain = builder.gain;
        this.gainLF = builder.gainLF;
        this.gainHF = builder.gainHF;
    }

    public float getGain() {
        return this.gain;
    }

    public float getGainLF() {
        return this.gainLF;
    }

    public float getGainHF() {
        return this.gainHF;
    }

    public static class Builder {
        private float gain = 1.0f;
        private float gainLF = 1.0f;
        private float gainHF = 1.0f;

        public Builder setGain(float gain) {
            this.gain = gain;
            return this;
        }

        public Builder setGainLF(float gainLF) {
            this.gainLF = gainLF;
            return this;
        }

        public Builder setGainHF(float gainHF) {
            this.gainHF = gainHF;
            return this;
        }

        public FilterParams build() {
            return new FilterParams(this);
        }
    }
}

