/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.client.soundfilter.registry;

import java.util.EnumMap;
import java.util.Map;
import net.reaper.ancientnature.api.client.soundfilter.filter.LowPassFilter;
import net.reaper.ancientnature.api.client.soundfilter.filter.NoneFilter;
import net.reaper.ancientnature.api.client.soundfilter.registry.Filter;
import net.reaper.ancientnature.api.client.soundfilter.registry.SoundFilterType;

public class SoundFilters {
    private static final Map<SoundFilterType, Filter> FILTERS = new EnumMap<SoundFilterType, Filter>(SoundFilterType.class);

    public static Filter get(SoundFilterType type) {
        if (!FILTERS.containsKey((Object)type)) {
            throw new IllegalArgumentException("Unknown filter type: " + type);
        }
        return FILTERS.get((Object)type);
    }

    static {
        FILTERS.put(SoundFilterType.LOW_PASS, new LowPassFilter());
        FILTERS.put(SoundFilterType.NONE, new NoneFilter());
    }
}

