/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.animator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.IAnimation;
import net.reaper.ancientnature.api.common.animator.MobAnimator;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public final class AnimBlend {
    private static final Map<Integer, BlendState> STATES = new LinkedHashMap<Integer, BlendState>();

    private AnimBlend() {
    }

    public static void applyBlended(HierarchicalModel<?> model, MobAnimator<?> animator, float ageInTicks, long blendDuration) {
        float deltaTicks;
        if (animator == null) {
            return;
        }
        int id = animator.getEntity().m_19879_();
        BlendState state = STATES.computeIfAbsent(id, k -> new BlendState());
        String curName = null;
        IAnimation current = animator.getCurrentAnimation();
        if (current != MobAnimator.EMPTY && animator.isPlaying(current.getName())) {
            curName = current.getName();
        }
        if (!Objects.equals(curName, state.lastAnim)) {
            if (state.lastAnim != null) {
                try {
                    IAnimation last = animator.getByName(state.lastAnim);
                    state.prevAnim = state.lastAnim;
                    state.prevAccum = last.getData().m_216981_();
                }
                catch (Exception e) {
                    state.prevAnim = null;
                    state.prevAccum = 0L;
                }
            } else {
                state.prevAnim = null;
                state.prevAccum = 0L;
            }
            state.lastAnim = curName;
            state.blend = 0.0f;
        }
        if ((deltaTicks = ageInTicks - state.lastAgeTicks) < 0.0f) {
            deltaTicks = 0.0f;
        }
        long deltaMs = (long)(deltaTicks * 1000.0f / 20.0f);
        state.lastAgeTicks = ageInTicks;
        if (state.blend < 1.0f) {
            if (blendDuration > 0L) {
                state.blend += (float)deltaMs / (float)blendDuration;
                if (state.blend > 1.0f) {
                    state.blend = 1.0f;
                }
            } else {
                state.blend = 1.0f;
            }
        }
        ArrayList<AnimationInstance> instances = new ArrayList<AnimationInstance>();
        if (state.prevAnim != null && state.blend < 1.0f) {
            IAnimation prev = animator.getByName(state.prevAnim);
            instances.add(new AnimationInstance(prev.getData().definition, state.prevAccum, 1.0f - state.blend));
        }
        if (curName != null) {
            IAnimation cur = animator.getByName(curName);
            AnimData curData = cur.getData();
            curData.m_216974_(ageInTicks, 1.0f);
            if (curData.m_216984_()) {
                long curAccum = curData.m_216981_();
                float weight = state.prevAnim != null && state.blend < 1.0f ? state.blend : 1.0f;
                instances.add(new AnimationInstance(curData.definition, curAccum, weight));
            }
        }
        if (instances.isEmpty()) {
            return;
        }
        AnimBlend.animateBlendedImpl(model, instances, 1.0f);
        if (state.blend >= 1.0f) {
            state.prevAnim = null;
            state.prevAccum = 0L;
        }
    }

    private static void animateBlendedImpl(HierarchicalModel<?> model, List<AnimationInstance> instances, float scale) {
        float totalWeight = 0.0f;
        for (AnimationInstance ins : instances) {
            totalWeight += ins.weight;
        }
        if (totalWeight <= 0.0f) {
            return;
        }
        float invTotal = 1.0f / totalWeight;
        HashMap<String, Map> accumMap = new HashMap<String, Map>();
        for (AnimationInstance animationInstance : instances) {
            float normalizedWeight = animationInstance.weight * invTotal;
            AnimationDefinition def = animationInstance.def;
            for (Map.Entry entry : def.f_232257_().entrySet()) {
                String boneName = (String)entry.getKey();
                List channels = (List)entry.getValue();
                Map byTarget = accumMap.computeIfAbsent(boneName, k -> new HashMap());
                for (AnimationChannel channel : channels) {
                    Keyframe[] keyframes = channel.f_232212_();
                    if (keyframes.length == 0) continue;
                    float f = AnimBlend.getElapsedSeconds(def, animationInstance.accumulatedMs);
                    int i = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, idx -> f <= keyframes[idx].f_232283_()) - 1);
                    int j = Math.min(keyframes.length - 1, i + 1);
                    Keyframe kfA = keyframes[i];
                    Keyframe kfB = keyframes[j];
                    float between = f - kfA.f_232283_();
                    float alpha = j != i ? Mth.m_14036_((float)(between / (kfB.f_232283_() - kfA.f_232283_())), (float)0.0f, (float)1.0f) : 0.0f;
                    Vector3f interp = kfA.f_232285_().m_232222_(new Vector3f(), alpha, keyframes, i, j, scale);
                    Vector3f accum = byTarget.computeIfAbsent(channel.f_232211_(), t -> new Vector3f(0.0f, 0.0f, 0.0f));
                    accum.add(interp.x() * normalizedWeight, interp.y() * normalizedWeight, interp.z() * normalizedWeight);
                }
            }
        }
        for (Map.Entry entry : accumMap.entrySet()) {
            String boneName = (String)entry.getKey();
            Optional maybe = model.m_233393_(boneName);
            if (maybe.isEmpty()) continue;
            ModelPart part = (ModelPart)maybe.get();
            for (Map.Entry te : ((Map)entry.getValue()).entrySet()) {
                Vector3f result = (Vector3f)te.getValue();
                ((AnimationChannel.Target)te.getKey()).m_232247_(part, result);
            }
        }
    }

    private static float getElapsedSeconds(AnimationDefinition def, long accumulatedTimeMs) {
        float f = (float)accumulatedTimeMs / 1000.0f;
        return def.f_232256_() ? f % def.f_232255_() : f;
    }

    private static class BlendState {
        String lastAnim;
        String prevAnim;
        long prevAccum;
        float blend;
        float lastAgeTicks;

        private BlendState() {
        }
    }

    private record AnimationInstance(AnimationDefinition def, long accumulatedMs, float weight) {
    }
}

