/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.animator;

import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.ancientnature.mixin.accessor.AnimationStateAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AnimData
extends AnimationState {
    public static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();
    public final AnimationDefinition definition;
    @Nullable
    private LivingEntity entity;
    public float factorOld;
    public float factor = 1.0f;
    public float threshold = 0.9f;

    public AnimData(@NotNull AnimationDefinition definition) {
        this.definition = definition;
    }

    public void reset() {
        ((AnimationStateAccessor)((Object)this)).setAccumulatedTime(0L);
        ((AnimationStateAccessor)((Object)this)).setLastTime(0L);
    }

    @NotNull
    public String toString() {
        return this.definition.getClass().getSimpleName() + (String)(this.entity != null ? "@" + this.entity.m_7755_().getString() : "");
    }

    @NotNull
    public AnimationDefinition getDefinition() {
        return this.definition;
    }

    public void setEntity(@Nullable LivingEntity entity) {
        this.entity = entity;
    }

    public void updateWhen(boolean updateWhen, int tickCount) {
        this.factorOld = this.factor;
        float target = updateWhen ? 0.0f : 1.0f;
        float lerpSpeed = 0.4f;
        this.factor += (target - this.factor) * lerpSpeed;
        this.factor = Mth.m_14036_((float)this.factor, (float)0.0f, (float)1.0f);
        this.m_246184_(this.factor <= this.threshold + 1.0E-4f, tickCount);
    }

    public float factor(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.factorOld, (float)this.factor);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animate(@NotNull HierarchicalModel<?> model, @NotNull AnimationDefinition definition, float ageInTicks) {
        this.animate(model, definition, ageInTicks, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animate(@NotNull HierarchicalModel<?> model, @NotNull AnimationDefinition definition, float ageInTicks, float extraFactor) {
        this.m_216974_(ageInTicks, 1.0f);
        this.m_216979_(state -> KeyframeAnimations.m_232319_((HierarchicalModel)model, (AnimationDefinition)definition, (long)state.m_216981_(), (float)(1.0f - (extraFactor + this.factor(Minecraft.m_91087_().m_91296_()))), (Vector3f)ANIMATION_VECTOR_CACHE));
    }

    @Deprecated
    @NotNull
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("accumulatedTime", this.m_216981_());
        tag.m_128356_("lastTime", ((AnimationStateAccessor)((Object)this)).getLastTime());
        return tag;
    }

    @Deprecated
    public void read(@NotNull CompoundTag tag) {
        if (tag.m_128441_("accumulatedTime")) {
            ((AnimationStateAccessor)((Object)this)).setAccumulatedTime(tag.m_128454_("accumulatedTime"));
        }
        if (tag.m_128441_("lastTime")) {
            ((AnimationStateAccessor)((Object)this)).setLastTime(tag.m_128454_("lastTime"));
        }
    }

    @FunctionalInterface
    public static interface Provider {
        @NotNull
        public AnimData getData(@NotNull LivingEntity var1);
    }
}

