/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.animator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.IAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.MobAnimator;
import net.reaper.ancientnature.io.network.packet.AnimationSyncPacket;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAnimation
implements IAnimation {
    protected final String name;
    public final AnimData data;
    protected final int durationTicks;
    protected final Loop loop;
    protected boolean canInterrupt = true;
    protected int ticksRemaining = 0;
    protected boolean playing = false;
    protected MobAnimator<?> animator;
    @Nullable
    protected String nextAnimation = null;
    protected int tick = 0;
    protected final int priority;
    protected IPlayCondition playCondition = anim -> true;
    protected final List<AnimationListener> listeners = new ArrayList<AnimationListener>();
    @Nullable
    protected AnimData.Provider dataProvider;

    public BaseAnimation(@NotNull String name, @NotNull AnimData data, @NotNull Loop loop, int priority, float duration) {
        this.name = name;
        this.data = data;
        this.durationTicks = (int)(duration * 20.0f);
        this.loop = loop;
        this.priority = priority;
    }

    @NotNull
    public BaseAnimation addListener(@NotNull AnimationListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @NotNull
    public BaseAnimation removeListener(@NotNull AnimationListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public void attachAnimator(@NotNull MobAnimator<?> animator) {
        this.animator = animator;
        this.getData().setEntity((LivingEntity)animator.getEntity());
    }

    @Override
    public boolean canPlay() {
        return this.playCondition.canPlay(this);
    }

    @Override
    public void tick(int tick) {
        if (!this.playing) {
            return;
        }
        if (!this.canPlay() && this.canInterrupt) {
            if (this.animator != null) {
                this.syncStop((LivingEntity)this.animator.getEntity());
            }
            this.stop();
            return;
        }
        this.listeners.forEach(listener -> listener.onTick(this, this.tick));
        ++this.tick;
        if (--this.ticksRemaining <= 0) {
            if (this.loop == Loop.CYCLE && this.canPlay()) {
                this.restartCycle();
            } else {
                this.stop();
                this.triggerNextAnimation();
            }
        }
    }

    protected final void restartCycle() {
        this.ticksRemaining = this.getDuration();
        this.tick = 0;
        if (this.animator != null) {
            this.getData().m_216977_(((LivingEntity)this.animator.getEntity()).f_19797_);
        } else {
            this.getData().reset();
        }
    }

    @Override
    public void start() {
        if (this.playing) {
            return;
        }
        this.playing = true;
        this.ticksRemaining = this.getDuration();
        this.tick = 0;
        if (this.animator != null) {
            this.syncPlay((LivingEntity)this.animator.getEntity(), this.name, this.nextAnimation);
            this.getData().m_216977_(((LivingEntity)this.animator.getEntity()).f_19797_);
        } else {
            this.getData().reset();
        }
        this.listeners.forEach(listener -> listener.onStart(this));
    }

    @Override
    public void stop() {
        this.playing = false;
        this.getData().m_216973_();
        this.syncStop((LivingEntity)this.animator.getEntity());
        this.listeners.forEach(listener -> listener.onEnd(this));
    }

    protected void triggerNextAnimation() {
        IAnimation next;
        if (this.nextAnimation != null && this.animator != null && !(next = this.animator.getByName(this.nextAnimation)).isPlaying() && next.canPlay()) {
            next.start();
        }
    }

    public void syncPlay(@NotNull LivingEntity entity, @NotNull String name, @Nullable String next) {
        if (!entity.m_9236_().f_46443_) {
            AncientNature.NETWORK.sendToPlayersInLevel((ServerLevel)entity.m_9236_(), new AnimationSyncPacket(entity.m_19879_(), name, false, next));
        }
    }

    public void syncStop(@NotNull LivingEntity entity) {
        if (!entity.m_9236_().f_46443_) {
            AncientNature.NETWORK.sendToPlayersInLevel((ServerLevel)entity.m_9236_(), new AnimationSyncPacket(entity.m_19879_(), this.name, true, null));
        }
    }

    @NotNull
    public BaseAnimation setDataProvider(@NotNull AnimData.Provider provider) {
        this.dataProvider = provider;
        return this;
    }

    @Override
    @NotNull
    public AnimData getData() {
        if (this.dataProvider != null) {
            return this.dataProvider.getData((LivingEntity)this.animator.getEntity());
        }
        return this.data;
    }

    @NotNull
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("name", (Object)this.name).append("loop", (Object)this.loop).append("priority", this.priority).append("playing", this.playing).append("currentTick", this.tick).append("ticksRemaining", this.ticksRemaining).append("nextAnimation", (Object)this.nextAnimation).toString();
    }

    @Override
    @Deprecated
    @NotNull
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("playing", this.playing);
        tag.m_128405_("update", this.tick);
        tag.m_128405_("ticksRemaining", this.ticksRemaining);
        if (this.nextAnimation != null) {
            tag.m_128359_("nextAnimation", this.nextAnimation);
        }
        tag.m_128365_("data", (Tag)this.getData().write());
        return tag;
    }

    @Override
    @Deprecated
    public void read(@NotNull CompoundTag tag) {
        this.playing = tag.m_128471_("playing");
        this.tick = tag.m_128451_("update");
        this.ticksRemaining = tag.m_128451_("ticksRemaining");
        String string = this.nextAnimation = tag.m_128441_("nextAnimation") ? tag.m_128461_("nextAnimation") : null;
        if (tag.m_128441_("data")) {
            this.getData().read(tag.m_128469_("data"));
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public int getDuration() {
        return this.durationTicks;
    }

    @Override
    @NotNull
    public Loop getLoop() {
        return this.loop;
    }

    @Override
    public boolean canInterrupt() {
        return this.canInterrupt;
    }

    @NotNull
    public BaseAnimation setCanInterrupt(boolean canInterrupt) {
        this.canInterrupt = canInterrupt;
        return this;
    }

    public int getTicksRemaining() {
        return this.ticksRemaining;
    }

    public void setTicksRemaining(int ticksRemaining) {
        this.ticksRemaining = ticksRemaining;
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    @NotNull
    public MobAnimator<?> getAnimator() {
        return this.animator;
    }

    @NotNull
    public BaseAnimation setNextAnimation(@Nullable String nextAnimation) {
        this.nextAnimation = nextAnimation;
        return this;
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public IPlayCondition getPlayCondition() {
        return this.playCondition;
    }

    @NotNull
    public BaseAnimation setPlayCondition(IPlayCondition playCondition) {
        this.playCondition = playCondition;
        return this;
    }

    @NotNull
    public List<AnimationListener> getListeners() {
        return this.listeners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseAnimation)) {
            return false;
        }
        BaseAnimation b = (BaseAnimation)o;
        return Objects.equals(this.name, b.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

