/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.animator;

import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import org.jetbrains.annotations.NotNull;

public class HoldableAnimation {
    private final BaseAnimation startAnim;
    private final BaseAnimation loopAnim;
    private final BaseAnimation endAnim;
    private boolean active = false;

    public HoldableAnimation(@NotNull BaseAnimation startAnim, final @NotNull BaseAnimation loopAnim, final @NotNull BaseAnimation endAnim) {
        this.startAnim = startAnim;
        this.loopAnim = loopAnim;
        this.endAnim = endAnim;
        this.startAnim.addListener(new AnimationListener(){

            @Override
            public void onEnd(@NotNull BaseAnimation anim) {
                if (HoldableAnimation.this.active && loopAnim.getPlayCondition().canPlay(loopAnim)) {
                    anim.getAnimator().play(loopAnim);
                } else {
                    anim.getAnimator().play(endAnim);
                }
            }
        });
        this.loopAnim.addListener(new AnimationListener(){

            @Override
            public void onEnd(@NotNull BaseAnimation anim) {
                if (loopAnim.getPlayCondition().canPlay(loopAnim)) {
                    anim.getAnimator().play(loopAnim);
                } else {
                    anim.getAnimator().play(endAnim);
                }
            }
        });
        this.endAnim.addListener(new AnimationListener(){

            @Override
            public void onEnd(@NotNull BaseAnimation anim) {
                HoldableAnimation.this.active = false;
            }
        });
    }

    public void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.startAnim.getAnimator().play(this.startAnim);
    }

    public boolean isActive() {
        return this.active;
    }

    @NotNull
    public BaseAnimation getStartAnim() {
        return this.startAnim;
    }

    @NotNull
    public BaseAnimation getLoopAnim() {
        return this.loopAnim;
    }

    @NotNull
    public BaseAnimation getEndAnim() {
        return this.endAnim;
    }
}

