/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.animator;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationNotFoundException;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.EmptyAnimation;
import net.reaper.ancientnature.api.common.animator.IAnimateable;
import net.reaper.ancientnature.api.common.animator.IAnimation;
import net.reaper.ancientnature.api.common.animator.Loop;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public final class MobAnimator<T extends LivingEntity> {
    public static final AnimData EMPTY_DATA = new AnimData(new AnimationDefinition(0.0f, false, Map.of())){

        public void m_216977_(int tickCount) {
        }

        public void m_216973_() {
        }
    };
    public static final IAnimation EMPTY = EmptyAnimation.INSTANCE;
    private final T entity;
    private final Map<String, IAnimation> anims;

    public MobAnimator(@NotNull T entity) {
        this.entity = entity;
        this.anims = new LinkedHashMap<String, IAnimation>();
    }

    @NotNull
    public T getEntity() {
        return this.entity;
    }

    @NotNull
    public Map<String, IAnimation> getAnims() {
        return this.anims;
    }

    @NotNull
    public MobAnimator<T> register(IAnimation ... anims) {
        for (IAnimation anim : anims) {
            this.anims.put(anim.getName(), anim);
            if (!(anim instanceof BaseAnimation)) continue;
            BaseAnimation base = (BaseAnimation)anim;
            base.attachAnimator(this);
        }
        return this;
    }

    @NotNull
    public IAnimation getByName(String name) {
        IAnimation anim = this.anims.get(name);
        if (anim == null) {
            throw new AnimationNotFoundException(name);
        }
        return anim;
    }

    @NotNull
    public IAnimation get(@NotNull IAnimation animation) {
        return this.getByName(animation.getName());
    }

    @NotNull
    public IAnimation getCurrentAnimation() {
        return this.anims.values().stream().filter(IAnimation::isPlaying).min(Comparator.comparingInt(IAnimation::getPriority)).orElse(EMPTY);
    }

    public void tick(int tickCount) {
        ProfilerFiller profiler = this.entity.m_9236_().m_46473_();
        profiler.m_6180_("mobAnimator");
        for (IAnimation anim : this.anims.values()) {
            if (!anim.isPlaying()) continue;
            profiler.m_6180_(anim.getName());
            anim.tick(tickCount);
            profiler.m_7238_();
        }
        for (IAnimation anim : this.anims.values()) {
            IAnimation current;
            BaseAnimation base;
            if (anim.isPlaying() || !(anim instanceof BaseAnimation) || (base = (BaseAnimation)anim).getLoop() != Loop.CYCLE || !anim.canPlay() || (current = this.getCurrentAnimation()) != EMPTY && current.getPriority() < base.getPriority()) continue;
            profiler.m_6180_(anim.getName());
            anim.start();
            anim.tick(tickCount);
            profiler.m_7238_();
        }
        profiler.m_7238_();
    }

    public boolean play(@NotNull IAnimation animation) {
        IAnimation anim = this.getByName(animation.getName());
        if (anim != EMPTY && anim.canPlay() && !anim.isPlaying()) {
            for (IAnimation a : this.anims.values()) {
                if (!a.isPlaying() || a.getPriority() > anim.getPriority()) continue;
                a.stop();
            }
            anim.start();
            return true;
        }
        return false;
    }

    public boolean stop(@NotNull IAnimation animation) {
        IAnimation anim = this.getByName(animation.getName());
        if (anim != EMPTY && anim.isPlaying()) {
            anim.stop();
            if (anim instanceof BaseAnimation) {
                BaseAnimation base = (BaseAnimation)anim;
                if (!this.entity.m_9236_().f_46443_) {
                    base.syncStop((LivingEntity)this.entity);
                }
            }
            return true;
        }
        return false;
    }

    public int getAnimationTick(@NotNull String name) {
        IAnimation anim = this.getByName(name);
        if (anim instanceof BaseAnimation) {
            BaseAnimation base = (BaseAnimation)anim;
            return base.getTick();
        }
        return -1;
    }

    public boolean isPlaying(@NotNull String name) {
        return this.getByName(name).isPlaying();
    }

    public boolean isAnyPlaying(IAnimation ... anims) {
        return Arrays.stream(anims).anyMatch(anim -> this.getByName(anim.getName()).isPlaying());
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public MobAnimator<T> animate(@NotNull HierarchicalModel<?> model, @NotNull AnimData data, float ageInTicks, float speed) {
        data.m_216974_(ageInTicks, speed);
        data.m_216979_(state -> KeyframeAnimations.m_232319_((HierarchicalModel)model, (AnimationDefinition)data.definition, (long)state.m_216981_(), (float)1.0f, (Vector3f)new Vector3f()));
        return this;
    }

    public void resetAll() {
        for (IAnimation anim : this.anims.values()) {
            if (!(anim instanceof BaseAnimation)) continue;
            BaseAnimation base = (BaseAnimation)anim;
            base.setPlaying(false);
            base.setTicksRemaining(0);
            base.setTick(0);
            AnimData data = base.getData();
            data.reset();
            data.m_216973_();
            this.stop(base);
        }
    }

    @Deprecated
    @NotNull
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, IAnimation> entry : this.anims.entrySet()) {
            tag.m_128365_(entry.getKey(), (Tag)entry.getValue().write());
        }
        return tag;
    }

    @Deprecated
    public void read(@NotNull CompoundTag tag) {
        for (Map.Entry<String, IAnimation> entry : this.anims.entrySet()) {
            if (!tag.m_128441_(entry.getKey())) continue;
            entry.getValue().read(tag.m_128469_(entry.getKey()));
        }
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("MobAnimator{");
        sb.append("entity=").append(this.entity.m_7755_()).append(", id=").append(this.entity.m_19879_()).append(", activeAnimations=[");
        boolean first = true;
        for (IAnimation anim : this.anims.values()) {
            if (!anim.isPlaying()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(anim.getName());
            if (anim instanceof BaseAnimation) {
                BaseAnimation base = (BaseAnimation)anim;
                sb.append("(ticksRemaining=").append(base.getTicksRemaining()).append(", currentTick=").append(base.getTick()).append(")");
            }
            first = false;
        }
        if (first) {
            sb.append("NONE");
        }
        sb.append("], totalAnimations=").append(this.anims.size()).append('}');
        return sb.toString();
    }

    @Mod.EventBusSubscriber(modid="ancientnature")
    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void onEntityJoinLevel(@NotNull EntityJoinLevelEvent event) {
            Mob mob;
            Entity entity = event.getEntity();
            if (entity instanceof Mob && (mob = (Mob)entity) instanceof IAnimateable) {
                IAnimateable animateable = (IAnimateable)mob;
                try {
                    animateable.initAnimations();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

