/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.level.util;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public enum DayTime {
    SUNRISE(0, 6000),
    DAY(6000, 12000),
    SUNSET(12000, 18000),
    NIGHT(18000, 24000);

    private final int from;
    private final int to;

    private DayTime(int from, int to) {
        this.from = from;
        this.to = to;
    }

    @NotNull
    public static DayTime fromTick(long tick) {
        int time = (int)(tick % 24000L);
        return Arrays.stream(DayTime.values()).filter(dayTime -> time >= dayTime.from && time < dayTime.to).findFirst().orElse(NIGHT);
    }
}

