/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.level.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.reaper.ancientnature.api.common.level.util.ChunkCoords;
import net.reaper.ancientnature.api.common.level.util.DayTime;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class LevelUtils {
    public static final long TICKS_PER_DAY = 24000L;

    private LevelUtils() {
    }

    public static boolean isOfLevelType(@NotNull Level level, @NotNull ResourceKey<DimensionType> targetType) {
        return level.m_9598_().m_6632_(Registries.f_256787_).flatMap(registry -> registry.m_7854_((Object)level.m_6042_())).map(key -> key.equals((Object)targetType)).orElse(false);
    }

    public static boolean isPeaceful(@NotNull Level level) {
        return !level.m_6106_().m_5470_().m_46207_(GameRules.f_46134_) || level.m_46791_() == Difficulty.PEACEFUL;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ChunkCoords getChunkCoords(@NotNull BlockPos pos) {
        return new ChunkCoords(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    @NotNull
    public static DayTime getTimeOfDay(@NotNull Level level) {
        return DayTime.fromTick(level.m_46468_());
    }

    public static boolean isBlockLoaded(@Nullable BlockGetter level, @NotNull BlockPos pos) {
        return level != null && Level.m_46741_((BlockPos)pos) && ((LevelAccessor)level).isAreaLoaded(pos, 0);
    }

    public static double getDayProgress(@NotNull Level level) {
        return (double)(level.m_46468_() % 24000L) / 24000.0;
    }
}

