/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.misc;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;

public class RandomRunnable {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private int ticks;
    private final List<Action> actions = new CopyOnWriteArrayList<Action>();

    @NotNull
    public RandomRunnable addAction(@NotNull Action action) {
        this.actions.add(action);
        return this;
    }

    public void update() {
        ++this.ticks;
        this.actions.forEach(action -> {
            if (this.ticks % action.interval() == 0 && RANDOM.m_188501_() < action.chance()) {
                action.runnable().run();
            }
        });
    }

    public record Action(float chance, int interval, @NotNull Runnable runnable) {
        public Action(float chance, int interval, @NotNull Runnable runnable) {
            if (chance != Mth.m_14036_((float)chance, (float)0.0f, (float)1.0f)) {
                throw new RuntimeException("chance must be in bound 0 - 1");
            }
        }

        @Override
        @NotNull
        public String toString() {
            return String.format("Action chance: %s, interval: %s, runnable: %s", Float.valueOf(this.chance), this.interval, this.runnable);
        }
    }
}

