/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.tag;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.reaper.ancientnature.api.common.tag.TagType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityTag<T> {
    private final String name;
    private final TagType type;
    private final EntityDataAccessor<T> dataAccessor;
    private T defaultValue;

    public EntityTag(@NotNull Class<? extends Entity> entityClazz, String name, @NotNull TagType type) {
        this.name = name;
        this.type = type;
        this.dataAccessor = this.type.createAccessor(entityClazz);
        this.defaultValue = this.type.getOperations().defaultValue();
    }

    @NotNull
    public EntityTag<T> setDefault(@NonNull T value) {
        this.defaultValue = value;
        return this;
    }

    public void define(@NonNull Entity entity) {
        entity.f_19804_.m_135372_(this.dataAccessor, this.defaultValue);
    }

    public T get(@NonNull Entity entity) {
        return (T)entity.f_19804_.m_135370_(this.dataAccessor);
    }

    public void set(@NonNull Entity entity, T value) {
        entity.f_19804_.m_135381_(this.dataAccessor, value);
    }

    public void write(@NonNull Entity entity, @NonNull CompoundTag tag) {
        this.type.set(tag, this.name, this.get(entity));
    }

    public void read(@NonNull Entity entity, @NonNull CompoundTag tag) {
        Object value = this.type.get(tag, this.name);
        if (value != null) {
            this.set(entity, value);
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public TagType getType() {
        return this.type;
    }

    @NotNull
    public EntityDataAccessor<T> getDataAccessor() {
        return this.dataAccessor;
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public String toString() {
        return String.format("Name: %s, Type: %s", new Object[]{this.getName(), this.getType()});
    }
}

