/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.common.tag;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.IExtensibleEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TagType implements IExtensibleEnum
{
    INTEGER(new Operations(){

        @Override
        @NotNull
        public Object get(@NotNull CompoundTag tag, String name) {
            return tag.m_128451_(name);
        }

        @Override
        public void set(@NotNull CompoundTag tag, String name, Object value) {
            tag.m_128405_(name, ((Integer)value).intValue());
        }

        @Override
        @NotNull
        public EntityDataAccessor<?> createAccessor(Class<? extends Entity> entityClazz) {
            return SynchedEntityData.m_135353_(entityClazz, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        }

        @Override
        @NotNull
        public Object defaultValue() {
            return 0;
        }
    }),
    BOOLEAN(new Operations(){

        @Override
        @NotNull
        public Object get(@NotNull CompoundTag tag, String name) {
            return tag.m_128471_(name);
        }

        @Override
        public void set(@NotNull CompoundTag tag, String name, Object value) {
            tag.m_128379_(name, ((Boolean)value).booleanValue());
        }

        @Override
        @NotNull
        public EntityDataAccessor<?> createAccessor(Class<? extends Entity> entityClazz) {
            return SynchedEntityData.m_135353_(entityClazz, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        }

        @Override
        @NotNull
        public Object defaultValue() {
            return false;
        }
    }),
    STRING(new Operations(){

        @Override
        @NotNull
        public Object get(@NotNull CompoundTag tag, String name) {
            return tag.m_128461_(name);
        }

        @Override
        public void set(@NotNull CompoundTag tag, String name, Object value) {
            tag.m_128359_(name, (String)value);
        }

        @Override
        @NotNull
        public EntityDataAccessor<?> createAccessor(Class<? extends Entity> entityClazz) {
            return SynchedEntityData.m_135353_(entityClazz, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        }

        @Override
        @NotNull
        public Object defaultValue() {
            return "";
        }
    }),
    BLOCK_POS(new Operations(){

        @Override
        @Nullable
        public Object get(@NotNull CompoundTag tag, String name) {
            if (tag.m_128441_(name)) {
                CompoundTag posTag = tag.m_128469_(name);
                return new BlockPos(posTag.m_128451_("X"), posTag.m_128451_("Y"), posTag.m_128451_("Z"));
            }
            return null;
        }

        @Override
        public void set(@NotNull CompoundTag tag, String name, Object value) {
            if (!(value instanceof BlockPos)) {
                throw new IllegalArgumentException("Value must be of type BlockPos.");
            }
            BlockPos pos = (BlockPos)value;
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("X", pos.m_123341_());
            posTag.m_128405_("Y", pos.m_123342_());
            posTag.m_128405_("Z", pos.m_123343_());
            tag.m_128365_(name, (Tag)posTag);
        }

        @Override
        @NotNull
        public EntityDataAccessor<?> createAccessor(Class<? extends Entity> entityClazz) {
            return SynchedEntityData.m_135353_(entityClazz, (EntityDataSerializer)EntityDataSerializers.f_135038_);
        }

        @Override
        @NotNull
        public Object defaultValue() {
            return BlockPos.f_121853_;
        }
    });

    private final Operations operations;
    private final Object defaultValue;

    private TagType(Operations operations) {
        this.operations = operations;
        this.defaultValue = operations.defaultValue();
    }

    @Nullable
    public Object get(@NotNull CompoundTag tag, String name) {
        return this.operations.get(tag, name);
    }

    public void set(@NotNull CompoundTag tag, String name, Object value) {
        this.operations.set(tag, name, value);
    }

    @NotNull
    public EntityDataAccessor<?> createAccessor(@NotNull Class<? extends Entity> entityClazz) {
        return this.operations.createAccessor(entityClazz);
    }

    @NotNull
    public Operations getOperations() {
        return this.operations;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public static TagType create(String name, @NotNull Operations operations) {
        throw new IllegalStateException("Enum not extended: " + name);
    }

    public static interface Operations {
        @Nullable
        public Object get(@NotNull CompoundTag var1, String var2);

        public void set(@NotNull CompoundTag var1, String var2, Object var3);

        @NotNull
        public EntityDataAccessor<?> createAccessor(Class<? extends Entity> var1);

        @NotNull
        public Object defaultValue();
    }
}

