/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.io;

import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ModResources {
    private final String modId;

    public ModResources(@NotNull String modId) {
        this.modId = modId;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public ResourceLocation loc(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    @Contract(value="_ -> new")
    @NotNull
    public ResourceLocation modLoc(String path) {
        return this.loc(this.modId, path);
    }

    @Contract(value="_ -> new")
    @NotNull
    public ResourceLocation mc(String path) {
        return new ResourceLocation(path);
    }

    @Contract(value="_ -> new")
    @NotNull
    public ResourceLocation png(String path) {
        return this.modLoc("textures/" + path + ".png");
    }

    @Contract(value="_ -> new")
    @NotNull
    public ResourceLocation entity(String path) {
        return this.png("entity/" + path);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public ResourceLocation prepend(@NotNull ResourceLocation location, String prependation) {
        return this.loc(location.m_135827_(), prependation + location.m_135815_());
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public ResourceLocation extend(@NotNull ResourceLocation location, String extend) {
        return this.loc(location.m_135827_(), location.m_135815_() + extend);
    }

    @NotNull
    public String toString() {
        return this.modId;
    }
}

