/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.io.input;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.api.io.input.ActionType;
import net.reaper.ancientnature.api.io.input.InputKey;
import net.reaper.ancientnature.api.io.input.InputableEntity;
import net.reaper.ancientnature.api.io.input.KeyPressType;
import net.reaper.ancientnature.api.io.input.KeyState;
import net.reaper.ancientnature.io.network.packet.PlayerInputPacket;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class InputStateManager {
    public static final InputStateManager INSTANCE = new InputStateManager();
    private final Map<InputKey, KeyState> keyStates = new EnumMap<InputKey, KeyState>(InputKey.class);

    private InputStateManager() {
        for (InputKey key : InputKey.values()) {
            this.keyStates.put(key, new KeyState());
        }
    }

    public void updateKeyState(@NotNull InputKey key, boolean isPressed) {
        KeyState state = this.keyStates.get((Object)key);
        if (state != null) {
            state.setPressed(isPressed);
        }
    }

    public void update() {
        this.keyStates.values().forEach(state -> ++state.currentTick);
    }

    public boolean isKeyPress(@NotNull InputKey key, @NotNull KeyPressType type) {
        KeyState state = this.keyStates.get((Object)key);
        if (state != null) {
            return type.matches(state);
        }
        return false;
    }

    @Mod.EventBusSubscriber(modid="ancientnature", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    private static class Events {
        private static final Minecraft mc = Minecraft.m_91087_();

        private Events() {
        }

        @SubscribeEvent
        public static void onInputKey(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull InputEvent.Key event) {
            InputKey key;
            LocalPlayer player = Events.mc.f_91074_;
            if (player != null && Minecraft.m_91087_().f_91080_ == null && (key = InputKey.fromKeyCode(event.getKey())) != null) {
                INSTANCE.updateKeyState(key, event.getAction() != 0);
            }
        }

        @SubscribeEvent
        public static void onMouseButton(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull InputEvent.MouseButton event) {
            InputKey key;
            LocalPlayer player = Events.mc.f_91074_;
            if (player != null && Minecraft.m_91087_().f_91080_ == null && (key = InputKey.fromKeyCode(event.getButton())) != null) {
                INSTANCE.updateKeyState(key, event.getAction() != 0);
            }
        }

        @SubscribeEvent
        public static void onInteractionKeyMappingTriggered(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull InputEvent.InteractionKeyMappingTriggered event) {
            InputableEntity inputable;
            Entity entity;
            LocalPlayer player = Events.mc.f_91074_;
            if (player != null && (entity = player.m_20202_()) instanceof InputableEntity && (inputable = (InputableEntity)entity).isActionDenied(ActionType.fromEvent(event))) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onClientTick(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull TickEvent.ClientTickEvent event) {
            LocalPlayer player = Events.mc.f_91074_;
            if (player != null && event.phase == TickEvent.Phase.START) {
                INSTANCE.update();
                block0: for (InputKey key : InputKey.values()) {
                    for (KeyPressType type : KeyPressType.values()) {
                        if (!INSTANCE.isKeyPress(key, type)) continue;
                        AncientNature.NETWORK.sendToServer(new PlayerInputPacket(key, type));
                        continue block0;
                    }
                }
            }
        }
    }
}

