/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.io.input;

import net.reaper.ancientnature.api.io.input.KeyState;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KeyPressType {
    HOLD{

        @Override
        public boolean matches(@NotNull KeyState state) {
            return state.isPressed;
        }
    }
    ,
    PRESSED{

        @Override
        public boolean matches(@NotNull KeyState state) {
            return state.isPressed && !state.wasPressed;
        }
    }
    ,
    RELEASED{

        @Override
        public boolean matches(@NotNull KeyState state) {
            if (state.justReleased) {
                state.justReleased = false;
                return true;
            }
            return false;
        }
    }
    ,
    DOUBLE_PRESSED{

        @Override
        public boolean matches(@NotNull KeyState state) {
            return state.isDoublePressed();
        }
    }
    ,
    NONE{

        @Override
        public boolean matches(@NotNull KeyState state) {
            return !state.isPressed;
        }
    };


    public abstract boolean matches(@NotNull KeyState var1);
}

