/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.io.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.reaper.ancientnature.api.io.network.IPacket;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNetworkPacket<T extends AbstractNetworkPacket<T>>
implements IPacket {
    @Override
    public void encode(FriendlyByteBuf buf) {
        this.write(buf);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.read(buf);
    }

    @Override
    public void handle(@NotNull Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        if (this.canExecute(ctx)) {
            ctx.enqueueWork(() -> this.execute(context));
        }
        ctx.setPacketHandled(true);
    }

    protected abstract void read(@NotNull FriendlyByteBuf var1);

    protected abstract void write(@NotNull FriendlyByteBuf var1);

    protected abstract void execute(@NotNull Supplier<NetworkEvent.Context> var1);

    protected boolean canExecute(NetworkEvent.Context context) {
        return true;
    }
}

