/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.api.io.network;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.reaper.ancientnature.api.common.misc.ReflectionUtils;
import net.reaper.ancientnature.api.io.network.AbstractNetworkPacket;
import net.reaper.ancientnature.api.io.network.PacketSide;
import net.reaper.ancientnature.api.io.network.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkCreator {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final SimpleChannel channel;
    private int id = 0;
    private final Set<Class<?>> registeredPackets = new HashSet();

    private NetworkCreator(ResourceLocation channelName, String protocolVersion) {
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).clientAcceptedVersions(protocolVersion::equals).serverAcceptedVersions(protocolVersion::equals).networkProtocolVersion(() -> protocolVersion).simpleChannel();
        this.logger.info(String.format("Initialized channel: %s, version: %s", channelName, protocolVersion));
    }

    @NotNull
    public static NetworkCreator create(String modId, int version) {
        return NetworkCreator.create(modId, "main_channel", String.valueOf(version));
    }

    @NotNull
    public static NetworkCreator create(String modId, String channelName, String version) {
        return new NetworkCreator(new ResourceLocation(modId, channelName), version);
    }

    @NotNull
    public static Builder builder(ResourceLocation channelName) {
        return new Builder(channelName);
    }

    private boolean getSide(NetworkEvent.Context context, @NotNull Side side) {
        return side.matches(context.getDirection().getReceptionSide());
    }

    private <T extends AbstractNetworkPacket<T>> T decodePacket(@NotNull Class<T> clazz, @NotNull FriendlyByteBuf buf) {
        AbstractNetworkPacket instance = (AbstractNetworkPacket)ReflectionUtils.instantiate(clazz);
        instance.decode(buf);
        return (T)instance;
    }

    private <T extends AbstractNetworkPacket<T>> void handlePacket(T msg, @NotNull NetworkEvent.Context ctx, Side side) {
        if (this.getSide(ctx, side)) {
            msg.handle(() -> ctx);
        }
    }

    @NotNull
    public SimpleChannel getChannel() {
        return this.channel;
    }

    @NotNull
    public <T extends AbstractNetworkPacket<T>> NetworkCreator regPacket(@NotNull Class<T> packetClazz) {
        if (!this.registeredPackets.add(packetClazz)) {
            throw new IllegalStateException("Packet: " + packetClazz.getName() + " already registered!");
        }
        PacketSide annotation = ReflectionUtils.getAnnotation(packetClazz, PacketSide.class);
        Side side = annotation.side();
        this.channel.registerMessage(this.id++, packetClazz, AbstractNetworkPacket::encode, buf -> this.decodePacket(packetClazz, (FriendlyByteBuf)buf), (msg, ctx) -> this.handlePacket(msg, (NetworkEvent.Context)ctx.get(), side));
        this.logger.info("Registered packet: " + packetClazz.getSimpleName() + " with ID " + (this.id - 1));
        return this;
    }

    @NotNull
    public <P> NetworkCreator sendToServer(@NotNull P packet) {
        this.channel.sendToServer(packet);
        return this;
    }

    @NotNull
    public <P> NetworkCreator sendToClient(@Nullable Player player, @NotNull P packet) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packet);
        }
        return this;
    }

    @NotNull
    public <P> NetworkCreator sendToPlayersInLevel(@NotNull ServerLevel level, @NotNull P packet) {
        this.channel.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level).m_46472_()), packet);
        return this;
    }

    @NotNull
    public <P> NetworkCreator sendToTracking(ServerPlayer trackingTarget, P packet) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> trackingTarget), packet);
        return this;
    }

    @NotNull
    public <P> NetworkCreator sendToTracking(BlockPos pos, ServerLevel level, P packet) {
        this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), packet);
        return this;
    }

    @NotNull
    public <P> NetworkCreator sendToAll(P packet) {
        this.channel.send(PacketDistributor.ALL.noArg(), packet);
        return this;
    }

    public static class Builder {
        private final ResourceLocation channelName;
        private String version = "1";

        public Builder(ResourceLocation channelName) {
            this.channelName = channelName;
        }

        public Builder version(int version) {
            this.version = String.valueOf(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public NetworkCreator build() {
            return new NetworkCreator(this.channelName, this.version);
        }
    }
}

