/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.base.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.registries.ForgeRegistries;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.enums.Gender;

public abstract class SleepAnimalModel<T extends BaseSleepingAnimal>
extends HierarchicalModel<T> {
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(pEntity, pNetHeadYaw, pLimbSwingAmount, pAgeInTicks);
        this.dynamicTail(pEntity);
        float moveX = (float)(pEntity.m_20185_() - ((BaseSleepingAnimal)pEntity).f_19854_);
        float moveZ = (float)(pEntity.m_20189_() - ((BaseSleepingAnimal)pEntity).f_19856_);
        float speed = Mth.m_14116_((float)(moveX * moveX + moveZ * moveZ));
        if ((((BaseSleepingAnimal)pEntity).f_267362_.m_267780_() && !pEntity.m_6069_() && !pEntity.m_20142_() || this.getRunAnim() == null && this.getSwimAnim() == null) && this.getWalkAnim() != null) {
            this.m_267799_(this.getWalkAnim(), pLimbSwing, pLimbSwingAmount, 2.0f, 4.0f);
        }
        if (pEntity.m_20142_() && !pEntity.m_6069_() && this.getRunAnim() != null) {
            this.m_267799_(this.getRunAnim(), pLimbSwing, pLimbSwingAmount, this.getMaxRunAnimSpeed(), 2.0f);
        }
        if (this.getSwimAnim() != null) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).swimAnimation, this.getSwimAnim(), pAgeInTicks, 1.0f + Math.min(speed * 1.5f, 1.5f));
        }
        if (this.getIdleAnim() != null && (double)speed <= 0.05) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).idleAnimation, this.getIdleAnim(), pAgeInTicks, 1.0f);
        }
        if (this.getSitAnim() != null) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).sitAnimation, this.getSitAnim(), pAgeInTicks, 1.0f);
        }
        if (this.getSleepAnim() != null) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).sleepAnimation, this.getSleepAnim(), pAgeInTicks, 1.0f);
        }
        if (this.getEatAnim() != null) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).eatAnimation, this.getEatAnim(), pAgeInTicks, 1.0f);
        }
        if (this.getAttackAnim() != null) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).attackAnimation, this.getAttackAnim(), pAgeInTicks, 1.0f);
        }
        if (this.getDownAnim() != null) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).downAnimation, this.getDownAnim(), pAgeInTicks, 1.0f);
        }
        if (this.getFallAsleepAnim() != null) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).fallAlseepAnimation, this.getFallAsleepAnim(), pAgeInTicks, 1.0f);
        }
        if (this.getWakeUpAnim() != null) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).wakeUpAnimation, this.getWakeUpAnim(), pAgeInTicks, 1.0f);
        }
        if (this.getUpAnim() != null) {
            this.m_233385_(((BaseSleepingAnimal)pEntity).upAnimation, this.getUpAnim(), pAgeInTicks, 1.0f);
        }
    }

    protected abstract void dynamicTail(T var1);

    public abstract AnimationDefinition getWalkAnim();

    public abstract AnimationDefinition getIdleAnim();

    public abstract AnimationDefinition getSitAnim();

    public abstract AnimationDefinition getSleepAnim();

    public abstract AnimationDefinition getRunAnim();

    public abstract AnimationDefinition getSwimAnim();

    public abstract AnimationDefinition getEatAnim();

    public abstract AnimationDefinition getAttackAnim();

    public abstract AnimationDefinition getDownAnim();

    public abstract AnimationDefinition getFallAsleepAnim();

    public abstract AnimationDefinition getDanceAnim();

    public abstract AnimationDefinition getWakeUpAnim();

    public abstract AnimationDefinition getUpAnim();

    public abstract AnimationDefinition getRoarAnim();

    public abstract float getMaxRunAnimSpeed();

    protected abstract void applyHeadRotation(T var1, float var2, float var3, float var4);

    public ResourceLocation getTexture(T pEntity) {
        String name = ForgeRegistries.ENTITY_TYPES.getKey((Object)pEntity.m_6095_()).m_135815_();
        String path = "textures/entity/" + name + "/" + name + (((BaseAnimal)pEntity).getGender() == Gender.MALE ? "_male" : "_female") + ".png";
        return AncientNature.modLoc(path);
    }

    public float shadowRadius() {
        return 1.0f;
    }
}

