/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.base.model;

import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.enums.Gender;
import org.jetbrains.annotations.NotNull;

public abstract class SmartAnimalModel<T extends BaseAnimal>
extends HierarchicalModel<T> {
    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(entity, netHeadYaw, limbSwingAmount, ageInTicks);
        this.dynamicTail(entity);
        if (((BaseAnimal)entity).f_267362_.m_267780_() && (!entity.m_20142_() || this.getRunAnim() == null) && this.getWalkAnim() != null) {
            this.m_267799_(this.getWalkAnim(), limbSwing, limbSwingAmount, 1.0f, 2.0f);
        }
        if (entity.m_20142_() && this.getRunAnim() != null) {
            this.m_267799_(this.getRunAnim(), limbSwing, limbSwingAmount, 1.0f, 2.0f);
        }
        if (this.getIdleAnim() != null && !((BaseAnimal)entity).f_267362_.m_267780_()) {
            this.m_233385_(((BaseAnimal)entity).idleAnimation, this.getIdleAnim(), ageInTicks, 1.0f);
        }
        if (this.getEatAnim() != null) {
            this.m_233385_(((BaseAnimal)entity).eatAnimation, this.getEatAnim(), ageInTicks, 1.0f);
        }
        if (this.getAttackAnim() != null) {
            this.m_233385_(((BaseAnimal)entity).attackAnimation, this.getAttackAnim(), ageInTicks, 1.0f);
        }
    }

    protected abstract void dynamicTail(@NotNull T var1);

    protected abstract void applyHeadRotation(@NotNull T var1, float var2, float var3, float var4);

    public abstract AnimationDefinition getWalkAnim();

    public abstract AnimationDefinition getIdleAnim();

    public abstract AnimationDefinition getSitAnim();

    public abstract AnimationDefinition getSleepAnim();

    public abstract AnimationDefinition getRunAnim();

    public abstract AnimationDefinition getEatAnim();

    public abstract AnimationDefinition getAttackAnim();

    public abstract AnimationDefinition getDownAnim();

    public abstract AnimationDefinition getFallAsleepAnim();

    public abstract AnimationDefinition getWakeUpAnim();

    public abstract AnimationDefinition getUpAnim();

    public abstract AnimationDefinition getRoarAnim();

    public ResourceLocation getTexture(@NotNull T entity) {
        String name = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).m_135815_();
        String path = "textures/entity/" + name + "/" + name + (((BaseAnimal)entity).getGender() == Gender.MALE ? "_male" : "_female") + ".png";
        return AncientNature.modLoc(path);
    }

    public float shadowRadius() {
        return 1.0f;
    }
}

