/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.base.model;

import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.util.Mth;
import net.reaper.ancientnature.client.base.model.SmartAnimalModel;
import net.reaper.ancientnature.client.base.model.TiltParams;
import net.reaper.ancientnature.common.base.BaseWaterAnimal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SmartWaterAnimalModel<T extends BaseWaterAnimal>
extends SmartAnimalModel<T> {
    @Override
    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.getFlopAnim() != null) {
            // empty if block
        }
        netHeadYaw = Mth.m_14036_((float)netHeadYaw, (float)-360.0f, (float)360.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-360.0f, (float)360.0f);
        this.m_142109_().f_104203_ = headPitch * ((float)Math.PI / 180);
        this.m_142109_().f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.tilt(entity);
    }

    public void tilt(@NotNull T entity) {
        TiltParams tiltParams = this.getTiltParams(entity);
        if (tiltParams != null) {
            float maxRoll = tiltParams.getMaxAngle();
            float targetRoll = Math.max(-maxRoll, Math.min(maxRoll, (entity.m_146908_() - ((BaseWaterAnimal)entity).f_19859_) * 0.1f));
            if (tiltParams.isReversed()) {
                targetRoll = -targetRoll;
            }
            ((BaseWaterAnimal)entity).roll += (targetRoll - ((BaseWaterAnimal)entity).roll) * tiltParams.getSpeed();
            this.m_142109_().f_104205_ = ((BaseWaterAnimal)entity).roll;
        }
    }

    @Nullable
    protected abstract TiltParams getTiltParams(@NotNull T var1);

    public abstract AnimationDefinition getFlopAnim();
}

