/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.base.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.reaper.ancientnature.client.base.model.SleepAnimalModel;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SleepAnimalRenderer<T extends BaseSleepingAnimal>
extends MobRenderer<T, SleepAnimalModel<T>> {
    public SleepAnimalModel<T> smartModel;
    public SleepAnimalModel<T> babyModel;

    public SleepAnimalRenderer(EntityRendererProvider.Context pContext, SleepAnimalModel<T> pSmartModel) {
        super(pContext, pSmartModel, pSmartModel.shadowRadius());
        this.smartModel = pSmartModel;
        this.babyModel = this.getBabyModel(pContext);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pEntity) {
        return this.smartModel.getTexture(pEntity);
    }

    public void render(@NotNull T pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        if (this.babyModel != null) {
            this.f_115290_ = pEntity.m_6162_() ? this.babyModel : this.smartModel;
        }
        pMatrixStack.m_85836_();
        if (pEntity.m_6162_()) {
            int age = ((BaseAnimal)pEntity).getBabyAge();
            float growthFactor = 1.0f + (float)(age / 1000 + 24) / 62.0f;
            pMatrixStack.m_85841_(growthFactor, growthFactor, growthFactor);
        }
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }

    @Nullable
    public SleepAnimalModel<T> getBabyModel(@NotNull EntityRendererProvider.Context ctx) {
        return null;
    }
}

