/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.base.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.reaper.ancientnature.client.base.model.SmartWaterAnimalModel;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.base.BaseWaterAnimal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartWaterAnimalRenderer<T extends BaseWaterAnimal>
extends MobRenderer<T, SmartWaterAnimalModel<T>> {
    public SmartWaterAnimalModel<T> smartModel;
    public SmartWaterAnimalModel<T> babyModel;

    public SmartWaterAnimalRenderer(EntityRendererProvider.Context pContext, SmartWaterAnimalModel<T> pSmartModel) {
        super(pContext, pSmartModel, pSmartModel.shadowRadius());
        this.smartModel = pSmartModel;
        this.babyModel = this.getBabyModel(pContext);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pEntity) {
        return this.smartModel.getTexture(pEntity);
    }

    public void render(@NotNull T pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        if (this.babyModel != null) {
            this.f_115290_ = pEntity.m_6162_() ? this.babyModel : this.smartModel;
        }
        pMatrixStack.m_85836_();
        if (pEntity.m_6162_()) {
            int age = ((BaseAnimal)pEntity).getBabyAge();
            float growthFactor = 1.0f + (float)(age / 1000 + 24) / 36.0f;
            pMatrixStack.m_85841_(growthFactor, growthFactor, growthFactor);
        }
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }

    @Nullable
    public SmartWaterAnimalModel<T> getBabyModel(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context) {
        return null;
    }
}

