/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.entity.model.adult;

import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.reaper.ancientnature.api.common.animator.AnimBlend;
import net.reaper.ancientnature.api.common.animator.IAnimation;
import net.reaper.ancientnature.api.common.animator.MobAnimator;
import net.reaper.ancientnature.client.base.model.SleepAnimalModel;
import net.reaper.ancientnature.client.entity.animation.adult.ThylacineAdultAnimation;
import net.reaper.ancientnature.common.entity.ThylacineEntity;
import net.reaper.ancientnature.common.enums.Gender;
import org.jetbrains.annotations.NotNull;

public class ThylacineAdultModel
extends SleepAnimalModel<ThylacineEntity> {
    ResourceLocation BENJAMIN = new ResourceLocation("ancientnature", "textures/entity/thylacine/thylacine_benjamin.png");
    private final ModelPart root;
    public ModelPart thylacine;
    public ModelPart body;
    public ModelPart head;
    public ModelPart jaw;
    public ModelPart tail;

    public ThylacineAdultModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.thylacine = this.root.m_171324_("thylacine");
        this.body = this.thylacine.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.tail = this.body.m_171324_("tail");
    }

    @Override
    public ResourceLocation getTexture(ThylacineEntity pEntity) {
        if (pEntity.m_8077_() && pEntity.m_7755_().getString().equals("Benjamin") && pEntity.getGender() == Gender.MALE) {
            return this.BENJAMIN;
        }
        return super.getTexture(pEntity);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)-3.0f));
        PartDefinition thylacine = root.m_171599_("thylacine", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = thylacine.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)3.0f));
        PartDefinition belly = body.m_171599_("belly", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -3.5f, -7.0f, 5.0f, 7.0f, 14.0f, new CubeDeformation(0.03f)).m_171514_(44, 0).m_171488_(-1.5f, 3.5f, 0.0f, 3.0f, 1.0f, 7.0f, new CubeDeformation(0.03f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(18, 21).m_171488_(-3.0f, -1.5f, -4.5f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-7.5f));
        PartDefinition ear_l = head.m_171599_("ear_l", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)-1.0f, (float)-0.5f));
        PartDefinition cube_r1 = ear_l.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(6, 46).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition ear_r = head.m_171599_("ear_r", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)-1.0f, (float)-0.5f));
        PartDefinition cube_r2 = ear_r.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(35, 25).m_171488_(-1.0f, -1.5f, -2.5f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(39, 33).m_171488_(-1.0f, 1.4f, -2.5f, 2.0f, 1.0f, 5.0f, new CubeDeformation(-0.02f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-7.0f));
        PartDefinition halo = head.m_171599_("halo", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, 0.5f, -1.5f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-3.0f, -0.5f, -1.0f, 6.0f, 1.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.5f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(27, 35).m_171488_(-1.0f, -0.5703f, -5.4689f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-4.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)7.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition left_front = thylacine.m_171599_("left_front", CubeListBuilder.m_171558_().m_171514_(6, 27).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)5.0f, (float)-3.0f));
        PartDefinition right_front = thylacine.m_171599_("right_front", CubeListBuilder.m_171558_().m_171514_(16, 37).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)5.0f, (float)-3.0f));
        PartDefinition left_back = thylacine.m_171599_("left_back", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)5.0f, (float)9.0f));
        PartDefinition right_back = thylacine.m_171599_("right_back", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)5.0f, (float)9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(@NotNull ThylacineEntity mob, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        MobAnimator animator = mob.getAnimator();
        this.applyHeadRotation(mob, netHeadYaw, headPitch, ageInTicks);
        if (mob.m_20142_()) {
            this.m_267799_(ThylacineAdultAnimation.SPRINT, limbSwing, limbSwingAmount, 2.0f, 2.4f);
        } else {
            this.m_267799_(ThylacineAdultAnimation.WALK, limbSwing, limbSwingAmount, 2.0f, 2.4f);
        }
        IAnimation current = animator.getCurrentAnimation();
        if (current != MobAnimator.EMPTY && animator.isPlaying(current.getName())) {
            AnimBlend.applyBlended(this, animator, ageInTicks, 200L);
        }
    }

    @Override
    public float shadowRadius() {
        return 0.6f;
    }

    @Override
    public AnimationDefinition getWalkAnim() {
        return ThylacineAdultAnimation.WALK;
    }

    @Override
    public AnimationDefinition getIdleAnim() {
        return ThylacineAdultAnimation.IDLE;
    }

    @Override
    public AnimationDefinition getSitAnim() {
        return ThylacineAdultAnimation.REST;
    }

    @Override
    public AnimationDefinition getSleepAnim() {
        return ThylacineAdultAnimation.SLEEP;
    }

    @Override
    public AnimationDefinition getRunAnim() {
        return ThylacineAdultAnimation.SPRINT;
    }

    @Override
    public AnimationDefinition getSwimAnim() {
        return ThylacineAdultAnimation.SWIM;
    }

    @Override
    public AnimationDefinition getEatAnim() {
        return ThylacineAdultAnimation.EAT;
    }

    @Override
    public AnimationDefinition getAttackAnim() {
        return ThylacineAdultAnimation.ATTACK;
    }

    @Override
    public AnimationDefinition getDownAnim() {
        return ThylacineAdultAnimation.SIT;
    }

    @Override
    public AnimationDefinition getFallAsleepAnim() {
        return ThylacineAdultAnimation.FALL_ASLEEP;
    }

    @Override
    public AnimationDefinition getWakeUpAnim() {
        return ThylacineAdultAnimation.WAKE_UP;
    }

    @Override
    public AnimationDefinition getUpAnim() {
        return ThylacineAdultAnimation.UP;
    }

    @Override
    public AnimationDefinition getRoarAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getDanceAnim() {
        return null;
    }

    @Override
    public float getMaxRunAnimSpeed() {
        return 1.0f;
    }

    @Override
    protected void applyHeadRotation(ThylacineEntity pEntity, float pNetHeadYaw, float pHeadPitch, float ageInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-10.0f, (float)10.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    @Override
    protected void dynamicTail(ThylacineEntity pEntity) {
        float targetYaw = pEntity.prevTailRot + (pEntity.tailRot - pEntity.prevTailRot) * Minecraft.m_91087_().getPartialTick();
        this.tail.f_104204_ = Mth.m_14179_((float)0.05f, (float)this.tail.f_104204_, (float)targetYaw);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

