/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.entity.model.adult;

import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.reaper.ancientnature.client.base.model.SmartAnimalModel;
import net.reaper.ancientnature.client.entity.animation.adult.WormAnimation;
import net.reaper.ancientnature.common.entity.WormEntity;
import org.jetbrains.annotations.NotNull;

public class WormModel
extends SmartAnimalModel<WormEntity> {
    private final ModelPart worm;
    private ModelPart front;
    private ModelPart middle;
    private ModelPart back;

    public WormModel(ModelPart root) {
        this.worm = root.m_171324_("worm");
        this.front = this.worm.m_171324_("front");
        this.middle = this.worm.m_171324_("middle");
        this.back = this.worm.m_171324_("back");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition worm = partdefinition.m_171599_("worm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)24.0f, (float)0.0f));
        PartDefinition front = worm.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-1.5f));
        PartDefinition middle = worm.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(5, 1).m_171488_(-0.5f, -1.0f, -1.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition back = worm.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)1.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    @Override
    public float shadowRadius() {
        return 0.2f;
    }

    @Override
    public AnimationDefinition getWalkAnim() {
        return WormAnimation.WALK;
    }

    @Override
    public AnimationDefinition getIdleAnim() {
        return WormAnimation.IDLE;
    }

    @Override
    public AnimationDefinition getSitAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getSleepAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getRunAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getEatAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getAttackAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getDownAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getFallAsleepAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getWakeUpAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getUpAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getRoarAnim() {
        return null;
    }

    @Override
    protected void applyHeadRotation(@NotNull WormEntity pEntity, float pNetHeadYaw, float pHeadPitch, float ageInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-10.0f, (float)10.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.worm.m_171324_((String)"front").f_104204_ = pNetHeadYaw * 0.0f;
        this.worm.m_171324_((String)"front").f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    @Override
    protected void dynamicTail(@NotNull WormEntity pEntity) {
        if (this == null) {
            return;
        }
    }

    public ModelPart m_142109_() {
        return this.worm;
    }
}

