/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.entity.model.baby;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.reaper.ancientnature.api.common.animator.AnimBlend;
import net.reaper.ancientnature.api.common.animator.IAnimation;
import net.reaper.ancientnature.api.common.animator.MobAnimator;
import net.reaper.ancientnature.client.base.model.SleepAnimalModel;
import net.reaper.ancientnature.client.entity.animation.baby.LizamberBabyAnimations;
import net.reaper.ancientnature.common.entity.LizamberEntity;
import org.jetbrains.annotations.NotNull;

public class LizamberBabyModel
extends SleepAnimalModel<LizamberEntity> {
    public final ModelPart Ambertile;
    public final ModelPart tail;
    public final ModelPart tail2;
    public final ModelPart body;
    public final ModelPart top;
    public final ModelPart neck;
    public final ModelPart head;

    public LizamberBabyModel(ModelPart root) {
        this.Ambertile = root.m_171324_("Ambertile");
        this.body = this.Ambertile.m_171324_("body");
        this.top = this.body.m_171324_("top");
        this.neck = this.top.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.tail = this.top.m_171324_("tail");
        this.tail2 = this.tail.m_171324_("tail2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Ambertile = partdefinition.m_171599_("Ambertile", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = Ambertile.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition top = body.m_171599_("top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.25f, (float)1.75f));
        PartDefinition belly = top.m_171599_("belly", CubeListBuilder.m_171558_().m_171514_(38, 40).m_171488_(0.0f, -2.5f, -0.5f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -0.5f, -6.5f, 6.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.25f, (float)-0.25f));
        PartDefinition tail = top.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-1.0f, -1.45f, 0.0f, 2.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 34).m_171488_(0.0f, -3.45f, 2.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.7f, (float)3.25f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.05f, (float)7.0f));
        PartDefinition neck = top.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171488_(-1.0f, -3.25f, -5.75f, 2.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(14, 31).m_171488_(0.0f, -4.25f, -4.75f, 0.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-5.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(14, 24).m_171488_(-1.5f, -1.0f, -3.9286f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(30, 24).m_171488_(-1.5f, -2.0f, -3.9286f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(20, 41).m_171488_(-0.5f, 0.0f, -6.9286f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(26, 36).m_171488_(-1.5f, -1.0f, -9.9286f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(38, 36).m_171488_(-1.5f, 1.0f, -9.9286f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(28, 41).m_171488_(-0.5f, 1.0f, -6.9286f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-1.75f, (float)-5.8214f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(34, 16).m_171488_(-1.5f, -1.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.02f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.4286f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(30, 30).m_171488_(-1.5f, 0.0f, -5.0f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 45).m_171488_(-0.5f, 0.0f, -8.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(8, 45).m_171488_(-0.5f, -0.9f, -8.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.01f)).m_171514_(0, 41).m_171488_(-1.0f, 0.0f, -11.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(-0.01f)).m_171514_(10, 41).m_171488_(-1.0f, -0.98f, -11.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)1.0714f));
        PartDefinition leg = body.m_171599_("leg", CubeListBuilder.m_171558_().m_171514_(32, 5).m_171488_(-1.5f, 0.0f, -4.6213f, 3.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-0.05f, (float)-5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition feet = leg.m_171599_("feet", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.45f, (float)-2.6213f));
        PartDefinition leg2 = body.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(32, 5).m_171488_(-1.5f, 0.0f, -4.6213f, 3.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-0.05f, (float)-5.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition feet2 = leg2.m_171599_("feet2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.45f, (float)-2.6213f));
        PartDefinition leg3 = body.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(32, 10).m_171488_(-0.3787f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-0.05f, (float)5.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition feet3 = leg3.m_171599_("feet3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.6213f, (float)-0.45f, (float)0.0f));
        PartDefinition leg4 = body.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(32, 13).m_171488_(-4.6213f, 0.0f, -1.5f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-0.05f, (float)5.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition feet4 = leg4.m_171599_("feet4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.6213f, (float)-0.45f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    protected void applyHeadRotation(LizamberEntity pEntity, float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.top.m_171324_((String)"neck").f_104204_ = pNetHeadYaw * 3.72E-7f;
        this.top.m_171324_((String)"neck").f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.neck.m_171324_((String)"head").f_104204_ = pNetHeadYaw * 0.01253292f;
        this.neck.m_171324_((String)"head").f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * 0.01253292f;
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        if (pEntity.m_5803_()) {
            this.top.m_171324_((String)"neck").f_104204_ = 0.0f;
            this.top.m_171324_((String)"neck").f_104203_ = 0.0f;
            this.neck.m_171324_((String)"head").f_104204_ = 0.0f;
            this.neck.m_171324_((String)"head").f_104203_ = 0.0f;
            this.head.f_104204_ = 0.0f;
            this.head.f_104203_ = 0.0f;
        }
    }

    @Override
    protected void dynamicTail(@NotNull LizamberEntity pEntity) {
        float targetYaw = pEntity.prevTailRot + (pEntity.tailRot - pEntity.prevTailRot) * Minecraft.m_91087_().getPartialTick();
        this.tail.f_104204_ = Mth.m_14179_((float)0.1f, (float)this.tail.f_104204_, (float)targetYaw);
        this.tail2.f_104204_ = Mth.m_14179_((float)0.2f, (float)this.tail2.f_104204_, (float)targetYaw);
    }

    public void setMatrixStack(@NotNull PoseStack pMatrixStack) {
        this.Ambertile.m_104299_(pMatrixStack);
        this.body.m_104299_(pMatrixStack);
    }

    @Override
    public void setupAnim(@NotNull LizamberEntity mob, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        MobAnimator animator = mob.getAnimator();
        this.applyHeadRotation(mob, netHeadYaw, headPitch, ageInTicks);
        if (mob.m_20142_()) {
            this.m_267799_(LizamberBabyAnimations.SPRINT, limbSwing, limbSwingAmount, 2.0f, 2.4f);
        } else {
            this.m_267799_(LizamberBabyAnimations.WALK, limbSwing, limbSwingAmount, 2.0f, 2.4f);
        }
        IAnimation current = animator.getCurrentAnimation();
        if (current != MobAnimator.EMPTY && animator.isPlaying(current.getName())) {
            AnimBlend.applyBlended(this, animator, ageInTicks, 200L);
        }
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.Ambertile;
    }

    @Override
    public AnimationDefinition getWalkAnim() {
        return LizamberBabyAnimations.WALK;
    }

    @Override
    public AnimationDefinition getIdleAnim() {
        return LizamberBabyAnimations.IDLE;
    }

    @Override
    public AnimationDefinition getSitAnim() {
        return LizamberBabyAnimations.REST;
    }

    @Override
    public AnimationDefinition getSleepAnim() {
        return LizamberBabyAnimations.SLEEPING;
    }

    @Override
    public AnimationDefinition getRunAnim() {
        return LizamberBabyAnimations.SPRINT;
    }

    @Override
    public AnimationDefinition getSwimAnim() {
        return LizamberBabyAnimations.SWIM;
    }

    @Override
    public AnimationDefinition getEatAnim() {
        return LizamberBabyAnimations.EAT;
    }

    @Override
    public AnimationDefinition getAttackAnim() {
        return LizamberBabyAnimations.ATTACK;
    }

    @Override
    public AnimationDefinition getDownAnim() {
        return LizamberBabyAnimations.DOWN;
    }

    @Override
    public AnimationDefinition getFallAsleepAnim() {
        return LizamberBabyAnimations.ASLEEP;
    }

    @Override
    public AnimationDefinition getWakeUpAnim() {
        return LizamberBabyAnimations.UP;
    }

    @Override
    public AnimationDefinition getUpAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getRoarAnim() {
        return LizamberBabyAnimations.ROAR;
    }

    @Override
    public AnimationDefinition getDanceAnim() {
        return null;
    }

    @Override
    public float getMaxRunAnimSpeed() {
        return 1.0f;
    }
}

