/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.entity.model.baby;

import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.reaper.ancientnature.api.common.animator.AnimBlend;
import net.reaper.ancientnature.api.common.animator.IAnimation;
import net.reaper.ancientnature.api.common.animator.MobAnimator;
import net.reaper.ancientnature.client.base.model.SleepAnimalModel;
import net.reaper.ancientnature.client.entity.animation.baby.ThylacineBabyAnimation;
import net.reaper.ancientnature.common.entity.ThylacineEntity;
import net.reaper.ancientnature.common.enums.Gender;
import org.jetbrains.annotations.NotNull;

public class ThylacineBabyModel
extends SleepAnimalModel<ThylacineEntity> {
    ResourceLocation BENJAMIN = new ResourceLocation("ancientnature", "textures/entity/thylacine/thylacine_baby_benjamin.png");
    private final ModelPart root;
    public ModelPart thylacine;
    public ModelPart body;
    public ModelPart head;
    public ModelPart tail;

    public ThylacineBabyModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.thylacine = this.root.m_171324_("thylacine");
        this.body = this.thylacine.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.tail = this.body.m_171324_("tail");
    }

    @Override
    public ResourceLocation getTexture(ThylacineEntity pEntity) {
        if (pEntity.m_8077_() && pEntity.m_7755_().getString().equals("Benjamin") && pEntity.getGender() == Gender.MALE) {
            return this.BENJAMIN;
        }
        return super.getTexture(pEntity);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition thylacine = root.m_171599_("thylacine", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = thylacine.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)1.0f));
        PartDefinition belly = body.m_171599_("belly", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -2.0f, -4.5f, 5.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-0.0858f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(10, 13).m_171488_(-3.0f, -1.5f, -2.8333f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(16, 23).m_171488_(2.0f, -2.5f, -1.8333f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 6).m_171488_(-3.0f, -2.5f, -1.8333f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-4.2525f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(19, 2).m_171488_(-1.0f, -1.75f, -3.0858f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(15, 19).m_171488_(-1.0f, 0.25f, -3.0858f, 2.0f, 1.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)0.25f, (float)-2.7475f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-3.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.3333f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(22, 20).m_171488_(-1.0f, 0.0f, -2.9858f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-2.8475f));
        PartDefinition halo = head.m_171599_("halo", CubeListBuilder.m_171558_().m_171514_(55, 0).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)-1.2475f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-0.5f, -0.2535f, -1.1823f, 1.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.7154f, (float)4.4889f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition left_front = thylacine.m_171599_("left_front", CubeListBuilder.m_171558_().m_171514_(8, 22).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-4.0f, (float)-2.5858f));
        PartDefinition right_front = thylacine.m_171599_("right_front", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-4.0f, (float)-2.5858f));
        PartDefinition left_back = thylacine.m_171599_("left_back", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-4.0f, (float)4.4142f));
        PartDefinition right_back = thylacine.m_171599_("right_back", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-4.0f, (float)4.4142f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(@NotNull ThylacineEntity mob, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        MobAnimator animator = mob.getAnimator();
        this.applyHeadRotation(mob, netHeadYaw, headPitch, ageInTicks);
        if (mob.m_20142_()) {
            this.m_267799_(ThylacineBabyAnimation.SPRINT, limbSwing, limbSwingAmount, 2.0f, 2.4f);
        } else {
            this.m_267799_(ThylacineBabyAnimation.WALK, limbSwing, limbSwingAmount, 2.0f, 2.4f);
        }
        IAnimation current = animator.getCurrentAnimation();
        if (current != MobAnimator.EMPTY && animator.isPlaying(current.getName())) {
            AnimBlend.applyBlended(this, animator, ageInTicks, 200L);
        }
    }

    @Override
    public float shadowRadius() {
        return 0.5f;
    }

    @Override
    public AnimationDefinition getWalkAnim() {
        return ThylacineBabyAnimation.WALK;
    }

    @Override
    public AnimationDefinition getIdleAnim() {
        return ThylacineBabyAnimation.IDLE;
    }

    @Override
    public AnimationDefinition getSitAnim() {
        return ThylacineBabyAnimation.REST;
    }

    @Override
    public AnimationDefinition getSleepAnim() {
        return ThylacineBabyAnimation.SLEEP;
    }

    @Override
    public AnimationDefinition getRunAnim() {
        return ThylacineBabyAnimation.SPRINT;
    }

    @Override
    public AnimationDefinition getSwimAnim() {
        return ThylacineBabyAnimation.SWIM;
    }

    @Override
    public AnimationDefinition getEatAnim() {
        return ThylacineBabyAnimation.EAT;
    }

    @Override
    public AnimationDefinition getAttackAnim() {
        return ThylacineBabyAnimation.ATTACK;
    }

    @Override
    public AnimationDefinition getDownAnim() {
        return ThylacineBabyAnimation.SIT;
    }

    @Override
    public AnimationDefinition getFallAsleepAnim() {
        return ThylacineBabyAnimation.FALL_ASLEEP;
    }

    @Override
    public AnimationDefinition getWakeUpAnim() {
        return ThylacineBabyAnimation.WAKE_UP;
    }

    @Override
    public AnimationDefinition getUpAnim() {
        return ThylacineBabyAnimation.UP;
    }

    @Override
    public AnimationDefinition getRoarAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getDanceAnim() {
        return null;
    }

    @Override
    public float getMaxRunAnimSpeed() {
        return 0.5f;
    }

    @Override
    protected void applyHeadRotation(ThylacineEntity pEntity, float pNetHeadYaw, float pHeadPitch, float ageInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-10.0f, (float)10.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    @Override
    protected void dynamicTail(ThylacineEntity pEntity) {
        float targetYaw = pEntity.prevTailRot + (pEntity.tailRot - pEntity.prevTailRot) * Minecraft.m_91087_().getPartialTick();
        this.tail.f_104204_ = Mth.m_14179_((float)0.05f, (float)this.tail.f_104204_, (float)targetYaw);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

