/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.entity.model.baby;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.reaper.ancientnature.client.base.model.SleepAnimalModel;
import net.reaper.ancientnature.client.entity.animation.baby.TuataraBabyAnimation;
import net.reaper.ancientnature.common.entity.TuataraEntity;
import org.jetbrains.annotations.NotNull;

public class TuataraBabyModel<T extends TuataraEntity>
extends SleepAnimalModel<T> {
    private final ModelPart tuatara;
    private final ModelPart top;
    private final ModelPart tail1;
    private final ModelPart tail_end;
    private final ModelPart body;
    private final ModelPart head;

    public TuataraBabyModel(ModelPart root) {
        this.tuatara = root.m_171324_("tuatara");
        this.top = this.tuatara.m_171324_("top");
        this.tail1 = this.top.m_171324_("tail1");
        this.tail_end = this.tail1.m_171324_("tail_end");
        this.body = this.top.m_171324_("body");
        this.head = this.top.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition tuatara = partdefinition.m_171599_("tuatara", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.5f, (float)24.0f, (float)-2.0f));
        PartDefinition top = tuatara.m_171599_("top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.5f, (float)0.0f, (float)2.0f));
        PartDefinition head = top.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-1.0f, -2.25f, -1.25f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.01f)).m_171514_(16, 20).m_171488_(0.0f, -3.25f, -1.25f, 0.0f, 4.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)-1.75f, (float)-1.75f));
        PartDefinition uppper_jaw = head.m_171599_("uppper_jaw", CubeListBuilder.m_171558_().m_171514_(22, 22).m_171488_(-1.0f, -2.0f, -2.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(16, 3).m_171488_(-1.0f, -1.0f, -3.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.25f, (float)-0.25f));
        PartDefinition eyes = uppper_jaw.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(26, 3).m_171488_(-1.0f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-1.0f));
        PartDefinition lower_jaw = head.m_171599_("lower_jaw", CubeListBuilder.m_171558_().m_171514_(12, 16).m_171488_(-1.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(12, 25).m_171488_(0.0f, -1.0f, -3.0f, 0.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)-1.25f, (float)-0.25f));
        PartDefinition body = top.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(1.5f, -0.375f, -2.75f, 1.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.5f, -0.375f, -2.75f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 22).m_171488_(0.0f, -1.375f, -0.75f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 12).m_171488_(-2.5f, -0.375f, -2.75f, 1.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.625f, (float)0.75f));
        PartDefinition tail1 = top.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(8, 20).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(22, 16).m_171488_(0.0f, -2.0f, 0.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)3.0f));
        PartDefinition tail_end = tail1.m_171599_("tail_end", CubeListBuilder.m_171558_().m_171514_(6, 25).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition front_right = tuatara.m_171599_("front_right", CubeListBuilder.m_171558_().m_171514_(22, 25).m_171488_(-1.0f, 0.05f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 10).m_171488_(-2.0f, 1.05f, -2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)-1.05f, (float)0.0f));
        PartDefinition front_left = tuatara.m_171599_("front_left", CubeListBuilder.m_171558_().m_171514_(24, 7).m_171488_(-1.0f, -0.05f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 7).m_171488_(-1.0f, 0.95f, -2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.5f, (float)-0.95f, (float)0.0f));
        PartDefinition back_left = tuatara.m_171599_("back_left", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171488_(-1.0f, -0.05f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(16, 0).m_171488_(-1.0f, 0.95f, -1.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.5f, (float)-0.95f, (float)5.0f));
        PartDefinition right_back = tuatara.m_171599_("right_back", CubeListBuilder.m_171558_().m_171514_(24, 13).m_171488_(-1.0f, -0.05f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 13).m_171488_(-2.0f, 0.95f, -1.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)-0.95f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(TuataraEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        this.dynamicTail(pEntity);
        this.applyHeadRotation(pEntity, pNetHeadYaw, pHeadPitch, pAgeInTicks);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.tuatara.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    protected void dynamicTail(@NotNull TuataraEntity pEntity) {
        float targetYaw = pEntity.prevTailRot + (pEntity.tailRot - pEntity.prevTailRot) * Minecraft.m_91087_().getPartialTick();
        this.tail1.f_104204_ = Mth.m_14179_((float)0.05f, (float)this.tail1.f_104204_, (float)targetYaw);
        this.tail_end.f_104204_ = Mth.m_14179_((float)0.07f, (float)this.tail_end.f_104204_, (float)targetYaw);
    }

    public void setMatrixStack(@NotNull PoseStack pMatrixStack) {
        this.tuatara.m_104299_(pMatrixStack);
        this.body.m_104299_(pMatrixStack);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.tuatara;
    }

    @Override
    public AnimationDefinition getWalkAnim() {
        return TuataraBabyAnimation.WALK;
    }

    @Override
    public AnimationDefinition getIdleAnim() {
        return TuataraBabyAnimation.IDLE;
    }

    @Override
    public AnimationDefinition getSitAnim() {
        return TuataraBabyAnimation.SLEEP;
    }

    @Override
    public AnimationDefinition getSleepAnim() {
        return TuataraBabyAnimation.SLEEP;
    }

    @Override
    public AnimationDefinition getRunAnim() {
        return TuataraBabyAnimation.SPRINT;
    }

    @Override
    public AnimationDefinition getSwimAnim() {
        return TuataraBabyAnimation.SWIM;
    }

    @Override
    public AnimationDefinition getEatAnim() {
        return TuataraBabyAnimation.EAT;
    }

    @Override
    public AnimationDefinition getAttackAnim() {
        return TuataraBabyAnimation.ATTACK;
    }

    @Override
    public AnimationDefinition getDownAnim() {
        return TuataraBabyAnimation.SIT;
    }

    @Override
    public AnimationDefinition getFallAsleepAnim() {
        return TuataraBabyAnimation.SLEEP;
    }

    @Override
    public AnimationDefinition getWakeUpAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getUpAnim() {
        return TuataraBabyAnimation.UP;
    }

    @Override
    public AnimationDefinition getRoarAnim() {
        return null;
    }

    @Override
    public AnimationDefinition getDanceAnim() {
        return null;
    }

    @Override
    public float getMaxRunAnimSpeed() {
        return 1.0f;
    }

    @Override
    protected void applyHeadRotation(TuataraEntity pEntity, float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.top.m_171324_((String)"head").f_104204_ = pNetHeadYaw * 3.72E-7f;
        this.top.m_171324_((String)"head").f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        if (pEntity.m_5803_()) {
            this.top.m_171324_((String)"head").f_104204_ = 0.0f;
            this.top.m_171324_((String)"head").f_104203_ = 0.0f;
            this.head.f_104204_ = 0.0f;
        }
    }
}

