/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.entity.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.reaper.ancientnature.common.entity.ANBoatEntity;
import net.reaper.ancientnature.common.entity.ANChestBoatEntity;

public class ANBoatRenderer
extends BoatRenderer {
    private final Map<ANBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(ANBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("ancientnature", ANBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (ANBoatEntity.Type)((Object)type), pChestBoat))));

    public ANBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(ANBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, ANBoatEntity.Type pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? ANBoatRenderer.createChestBoatModelName(pType) : ANBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.m_174023_(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(ANBoatEntity.Type pType) {
        return ANBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(ANBoatEntity.Type pType) {
        return ANBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel) {
        return new ModelLayerLocation(new ResourceLocation("ancientnature", pPath), pModel);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof ANBoatEntity) {
            ANBoatEntity modBoat = (ANBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getANBoatType());
        }
        if (boat instanceof ANChestBoatEntity) {
            ANChestBoatEntity modChestBoatEntity = (ANChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getANBoatType());
        }
        return null;
    }
}

