/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.client.base.renderer.SleepAnimalRenderer;
import net.reaper.ancientnature.client.entity.model.adult.JakapilAdultModel;
import net.reaper.ancientnature.client.model.ANLayers;
import net.reaper.ancientnature.common.entity.JakapilEntity;
import net.reaper.ancientnature.common.enums.Gender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class JakapilRenderer
extends SleepAnimalRenderer<JakapilEntity> {
    public JakapilRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new JakapilAdultModel(pContext.m_174023_(ANLayers.JAKAPIL_LAYER)));
        this.f_114477_ = 0.2f;
    }

    @Contract(value="_, _, _, _, -> new")
    @NotNull
    public Vec3 getWorldPosFromPart(@NotNull JakapilEntity mob, float yaw, float partialTick, ModelPart ... parts) {
        PoseStack matrix = new PoseStack();
        Vec3 pos = new Vec3(mob.m_20185_(), mob.m_20186_(), mob.m_20189_());
        matrix.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        matrix.m_85836_();
        this.m_7523_((LivingEntity)mob, matrix, (float)mob.f_19797_ + partialTick, yaw, partialTick);
        matrix.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        for (ModelPart part : parts) {
            part.m_104299_(matrix);
        }
        Vector4f v = matrix.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        Vector4f offset = new Vector4f(0.0f, 0.0f, -0.1f, 0.0f);
        v.add((Vector4fc)matrix.m_85850_().m_252922_().transform((Vector4fc)offset, new Vector4f()));
        matrix.m_85849_();
        return new Vec3((double)v.x, (double)v.y, (double)v.z);
    }

    @Override
    public void render(@NotNull JakapilEntity mob, float yaw, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffer, int light) {
        EntityModel entityModel = this.m_7200_();
        if (entityModel instanceof JakapilAdultModel) {
            JakapilAdultModel model = (JakapilAdultModel)entityModel;
            mob.mouthPos = this.getWorldPosFromPart(mob, yaw, partialTick, model.body, model.top, model.neck, model.head);
        }
        super.render(mob, yaw, partialTick, matrix, buffer, light);
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull JakapilEntity pEntity) {
        return new ResourceLocation("ancientnature", "textures/entity/jakapil/jakapil_" + (pEntity.getGender() == Gender.MALE ? "male" : "female") + ".png");
    }
}

