/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.reaper.ancientnature.client.base.model.SleepAnimalModel;
import net.reaper.ancientnature.client.base.renderer.SleepAnimalRenderer;
import net.reaper.ancientnature.client.entity.model.adult.TriceratopsAdultModel;
import net.reaper.ancientnature.client.entity.model.baby.TriceratopsBabyModel;
import net.reaper.ancientnature.client.model.ANLayers;
import net.reaper.ancientnature.client.renderer.layer.ANPassengerLayer;
import net.reaper.ancientnature.common.entity.TriceratopsEntity;
import net.reaper.ancientnature.common.enums.Gender;
import net.reaper.ancientnature.common.util.misc.ICustomPlayerRidePos;
import org.jetbrains.annotations.NotNull;

public class TriceratopsRenderer
extends SleepAnimalRenderer<TriceratopsEntity>
implements ICustomPlayerRidePos {
    public static final ResourceLocation SADDLE_LOCATION = new ResourceLocation("ancientnature", "textures/entity/triceratops.json/triceratops_saddle.png");
    public static final ResourceLocation HORRIDUS_MALE = new ResourceLocation("ancientnature", "textures/entity/triceratops.json/triceratops_horridus_male.png");
    public static final ResourceLocation HORRIDUS_FEMALE = new ResourceLocation("ancientnature", "textures/entity/triceratops.json/triceratops_horridus_female.png");
    public static final ResourceLocation PRORSUS_MALE = new ResourceLocation("ancientnature", "textures/entity/triceratops.json/triceratops_prorsus_male.png");
    public static final ResourceLocation PRORSUS_FEMALE = new ResourceLocation("ancientnature", "textures/entity/triceratops.json/triceratops_prorsus_male.png");
    public static SleepAnimalModel<TriceratopsEntity> adultModel;

    public TriceratopsRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new TriceratopsAdultModel(pContext.m_174023_(ANLayers.TRICERATOPS_LAYER)));
        this.m_115326_(new ANPassengerLayer(this));
        this.m_115326_((RenderLayer)new SaddleLayer((RenderLayerParent)this, (EntityModel)new TriceratopsAdultModel(pContext.m_174023_(ANLayers.TRICERATOPS_LAYER)), SADDLE_LOCATION));
    }

    @Override
    public <T extends LivingEntity> void applyRiderPose(@NotNull LivingEntity vehicle, HumanoidModel<T> pHumanoidModel, @NotNull T rider) {
        pHumanoidModel.f_102808_.f_104204_ = Mth.m_14036_((float)pHumanoidModel.f_102808_.f_104204_, (float)this.rad(-35.0f), (float)this.rad(35.0f));
        pHumanoidModel.f_102811_.f_104203_ = this.rad(-75.0f);
        pHumanoidModel.f_102811_.f_104205_ = this.rad(-5.0f);
        pHumanoidModel.f_102812_.f_104203_ = this.rad(-75.0f);
        pHumanoidModel.f_102812_.f_104205_ = this.rad(5.0f);
    }

    @Override
    public <T extends Entity> void applyRiderMatrixStack(@NotNull T vehicle, @NotNull PoseStack matrixStack) {
        ((TriceratopsAdultModel)this.m_7200_()).setMatrixStack(matrixStack);
        matrixStack.m_252880_(0.0f, 2.0f - vehicle.m_20206_(), 0.0f);
        matrixStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
        matrixStack.m_252781_(Axis.f_252495_.m_252977_(180.0f));
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull TriceratopsEntity pEntity) {
        if (pEntity.m_6162_() && pEntity.getGender().equals((Object)Gender.MALE) && pEntity.getVariant() == 0) {
            return new ResourceLocation("ancientnature", "textures/entity/triceratops.json/triceratops_horridus_male_baby.png");
        }
        if (pEntity.m_6162_() && pEntity.getGender().equals((Object)Gender.FEMALE) && pEntity.getVariant() == 0) {
            return new ResourceLocation("ancientnature", "textures/entity/triceratops.json/triceratops_horridus_female_baby.png");
        }
        if (pEntity.m_6162_() && pEntity.getGender().equals((Object)Gender.MALE)) {
            return new ResourceLocation("ancientnature", "textures/entity/triceratops.json/triceratops_prorsus_male_baby.png");
        }
        if (pEntity.m_6162_() && pEntity.getGender().equals((Object)Gender.FEMALE)) {
            return new ResourceLocation("ancientnature", "textures/entity/triceratops.json/triceratops_prorsus_female_baby.png");
        }
        int variant = pEntity.getVariant();
        return switch (variant) {
            default -> {
                if (pEntity.getGender() == Gender.MALE) {
                    yield PRORSUS_MALE;
                }
                yield PRORSUS_FEMALE;
            }
            case 0 -> {
                if (pEntity.getGender() == Gender.MALE) {
                    yield HORRIDUS_MALE;
                }
                yield HORRIDUS_FEMALE;
            }
            case 1 -> pEntity.m_6254_() ? SADDLE_LOCATION : SADDLE_LOCATION;
        };
    }

    @Override
    @Nullable
    public SleepAnimalModel<TriceratopsEntity> getBabyModel(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context pContext) {
        return new TriceratopsBabyModel(pContext.m_174023_(ANLayers.BABY_TRICERATOPS_LAYER));
    }
}

