/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.reaper.ancientnature.client.base.model.SmartWaterAnimalModel;
import net.reaper.ancientnature.client.base.renderer.SmartWaterAnimalRenderer;
import net.reaper.ancientnature.client.entity.model.adult.TrilobiteAdultModel;
import net.reaper.ancientnature.client.entity.model.baby.TrilobiteBabyModel;
import net.reaper.ancientnature.client.model.ANLayers;
import net.reaper.ancientnature.common.entity.TrilobiteEntity;
import net.reaper.ancientnature.common.enums.Gender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrilobiteRenderer
extends SmartWaterAnimalRenderer<TrilobiteEntity> {
    public static final Map<Integer, ResourceLocation> TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobite_1.png"));
        hashMap.put(1, new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobite_2.png"));
        hashMap.put(2, new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobite_3.png"));
        hashMap.put(3, new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobite_4.png"));
        hashMap.put(4, new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobite_5.png"));
    });
    private static final ResourceLocation MALE_BABY_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobite_baby_male.png");
    private static final ResourceLocation FEMALE_BABY_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobite_baby_female.png");
    private static final ResourceLocation MALE_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_male.png");
    private static final ResourceLocation FEMALE_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_female.png");
    private static final ResourceLocation YIN_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_male_yin.png");
    private static final ResourceLocation YANG_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_female_yang.png");
    private static final ResourceLocation MALE_SKULL_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_male_skull.png");
    private static final ResourceLocation FEMALE_SKULL_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_female_skull.png");
    private static final ResourceLocation MALE_BLUE_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_male_blue.png");
    private static final ResourceLocation FEMALE_BLUE_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_female_blue.png");
    private static final ResourceLocation MALE_WIMPOD_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_male_wimpod.png");
    private static final ResourceLocation FEMALE_WIMPOD_TEXTURE = new ResourceLocation("ancientnature", "textures/entity/trilobite/trilobites_female_wimpod.png");

    public TrilobiteRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new TrilobiteAdultModel(pContext.m_174023_(ANLayers.TRILOBITE_LAYER)));
    }

    @Override
    public void render(TrilobiteEntity entity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        super.render(entity, f, g, poseStack, multiBufferSource, i);
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull TrilobiteEntity pEntity) {
        if (!pEntity.m_6162_() && pEntity.m_8077_() && (pEntity.m_7770_().getString().equalsIgnoreCase("Wimpod") || pEntity.m_7770_().getString().equals("wimpod"))) {
            return pEntity.getGender() == Gender.MALE ? MALE_WIMPOD_TEXTURE : FEMALE_WIMPOD_TEXTURE;
        }
        if (pEntity.m_6162_()) {
            return pEntity.getGender() == Gender.MALE ? MALE_BABY_TEXTURE : FEMALE_BABY_TEXTURE;
        }
        return switch (pEntity.getVariant()) {
            case 1 -> {
                if (pEntity.getGender() == Gender.MALE) {
                    yield YIN_TEXTURE;
                }
                yield YANG_TEXTURE;
            }
            case 2 -> {
                if (pEntity.getGender() == Gender.MALE) {
                    yield MALE_SKULL_TEXTURE;
                }
                yield FEMALE_SKULL_TEXTURE;
            }
            case 3 -> {
                if (pEntity.getGender() == Gender.MALE) {
                    yield MALE_BLUE_TEXTURE;
                }
                yield FEMALE_BLUE_TEXTURE;
            }
            default -> pEntity.getGender() == Gender.MALE ? MALE_TEXTURE : FEMALE_TEXTURE;
        };
    }

    protected RenderType getRenderType(TrilobiteEntity entity, boolean isBodyVisible, boolean isTranslucent, boolean isGlowing) {
        ResourceLocation texture = this.getTextureLocation(entity);
        if (entity.m_6162_()) {
            return RenderType.m_110473_((ResourceLocation)texture);
        }
        if (!entity.m_6162_()) {
            return RenderType.m_110458_((ResourceLocation)texture);
        }
        return RenderType.m_110452_((ResourceLocation)texture);
    }

    @Override
    @Nullable
    public SmartWaterAnimalModel<TrilobiteEntity> getBabyModel(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context) {
        return new TrilobiteBabyModel<TrilobiteEntity>(context.m_174023_(ANLayers.BABY_TRILOBITE_LAYER));
    }
}

