/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.event;

import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.client.event.ModelRotationEvent;
import net.reaper.ancientnature.client.event.PlayerPoseEvent;
import net.reaper.ancientnature.client.event.renderer.FossilHighlightRenderer;
import net.reaper.ancientnature.client.event.renderer.TriceratopsSkullBlockHighlightRenderer;
import net.reaper.ancientnature.client.overlay.GuiManager;
import net.reaper.ancientnature.common.entity.ParanogmiusEntity;
import net.reaper.ancientnature.common.util.RenderUtil;
import net.reaper.ancientnature.common.util.misc.ICustomPlayerRidePos;
import net.reaper.ancientnature.core.proxy.ANClientProxy;
import net.reaper.ancientnature.core.registry.ANGuiElements;
import net.reaper.ancientnature.core.registry.ANMobEffects;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="ancientnature", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ANClientEvents {
    @SubscribeEvent
    public static void onComputeCameraAngle(ViewportEvent.ComputeCameraAngles pEvent) {
        MobEffectInstance fearEffect;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !Minecraft.m_91087_().m_91104_() && (fearEffect = player.m_21124_((MobEffect)ANMobEffects.FEAR.get())) != null) {
            int fearLevel = Math.min(fearEffect.m_19564_() + 1, 3);
            double intensity = 0.05 * (double)fearLevel;
            double strength = (double)player.m_217043_().m_188501_() * intensity;
            pEvent.getCamera().m_90568_(0.0, 0.0, strength);
        }
    }

    @SubscribeEvent
    public static void onClientTick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_9236_().f_46443_) {
            float targetVisionRange = player.m_21023_((MobEffect)ANMobEffects.ANOMALOUS.get()) ? (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) ? 5.0f : 0.0f) : 0.0f;
            ANClientProxy.waterVisionRange += (targetVisionRange - ANClientProxy.waterVisionRange) * 0.005f;
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Pre pEvent) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int screenWidth = pEvent.getWindow().m_85445_();
        int screenHeight = pEvent.getWindow().m_85446_();
        if (player == null) {
            return;
        }
        Entity vehicle = player.m_20202_();
        if (vehicle instanceof ParanogmiusEntity) {
            ParanogmiusEntity paranogmius = (ParanogmiusEntity)vehicle;
            ANGuiElements.swimInstinctBar.setProgress(paranogmius.m_21223_() / paranogmius.m_21233_());
            ANGuiElements.staminaBar.setProgress(paranogmius.getStamina() / 100.0f);
            ANGuiElements.timeBar.setProgress((float)ParanogmiusEntity.RIDEABLE_TICKS.get((Entity)paranogmius).intValue() / 1200.0f);
            GuiManager.render(pEvent.getGuiGraphics(), screenWidth, screenHeight, pEvent);
            if (pEvent.getOverlay().id().equals((Object)VanillaGuiOverlay.MOUNT_HEALTH.id())) {
                pEvent.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static <T extends LivingEntity> void onPlayerPose(PlayerPoseEvent<T> pEvent) {
        Mob mob;
        Mob vehicle;
        EntityRenderer<Mob> entityRenderer;
        Entity entity;
        T entity2 = pEvent.getEntity();
        if (entity2 instanceof Player && (entity = entity2.m_20202_()) instanceof Mob && (entityRenderer = RenderUtil.getEntityRenderer(vehicle = (mob = (Mob)entity))) instanceof ICustomPlayerRidePos) {
            ICustomPlayerRidePos customRidePos = (ICustomPlayerRidePos)entityRenderer;
            customRidePos.applyRiderPose((LivingEntity)vehicle, pEvent.getHumanoidModel(), entity2);
        }
    }

    @SubscribeEvent
    public static <T extends LivingEntity> void onModelRotation(ModelRotationEvent<T> pEvent) {
        T entity = pEvent.getEntity();
        if (entity instanceof Player) {
            pEvent.setCanceled(RenderUtil.getEntityRenderer(entity.m_20202_()) instanceof ICustomPlayerRidePos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPrePlayerRender(RenderPlayerEvent.Pre pEvent) {
        Player player = pEvent.getEntity();
        RenderPlayerEvent.Post event = new RenderPlayerEvent.Post(player, pEvent.getRenderer(), pEvent.getPartialTick(), pEvent.getPoseStack(), pEvent.getMultiBufferSource(), pEvent.getPackedLight());
        Set<UUID> set = RenderUtil.hiddenEntities;
        synchronized (set) {
            if (RenderUtil.hiddenEntities.remove(player.m_20148_()) && RenderUtil.shouldSkipRendering(false, Minecraft.m_91087_().m_91288_())) {
                MinecraftForge.EVENT_BUS.post((Event)event);
                pEvent.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        FossilHighlightRenderer.onRenderLevel(event);
    }

    @SubscribeEvent
    public static void onRenderBlockHighlight(RenderHighlightEvent.Block event) {
        TriceratopsSkullBlockHighlightRenderer.renderBlockHighlight(event);
    }
}

