/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.event.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.Tags;
import net.reaper.ancientnature.common.enchantment.ANEnchantments;
import net.reaper.ancientnature.common.enchantment.custom.IntuitionEnchantment;
import net.reaper.ancientnature.common.enchantment.custom.TetrachromatEnchantement;
import net.reaper.ancientnature.common.item.PaleontologistHatItem;
import net.reaper.ancientnature.core.registry.ANTags;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class FossilHighlightRenderer {
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !PaleontologistHatItem.isWearingPaleontologistHat()) {
            return;
        }
        ItemStack hat = player.m_6844_(EquipmentSlot.HEAD);
        ArrayList<BlockPos> targetBlocksPos = new ArrayList<BlockPos>();
        int radius = 10;
        if (EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ANEnchantments.INTUITION.get()), (LivingEntity)player) > 0) {
            radius = IntuitionEnchantment.getRadius(EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ANEnchantments.INTUITION.get()), (LivingEntity)player));
        }
        BlockPos playerPos = player.m_20183_();
        boolean hasMiner = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ANEnchantments.MINER.get()), (LivingEntity)player) > 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos currentPos = playerPos.m_7918_(x, y, z);
                    if (!player.m_9236_().m_8055_(currentPos).m_204336_(ANTags.Blocks.FOSSILS) && (!hasMiner || !player.m_9236_().m_8055_(currentPos).m_204336_(Tags.Blocks.ORES))) continue;
                    targetBlocksPos.add(currentPos);
                }
            }
        }
        if (targetBlocksPos.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
        RenderSystem.disableDepthTest();
        GL11.glEnable((int)2960);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.lineWidth((float)2.0f);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilMask((int)255);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        for (BlockPos pos : targetBlocksPos) {
            AABB boundingBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0);
            FossilHighlightRenderer.drawBox(poseStack, boundingBox, 0.0f, 0.0f, 0.0f, 1.0f);
        }
        GL11.glStencilFunc((int)517, (int)1, (int)255);
        GL11.glStencilMask((int)0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Color defaultColor = new Color(1.0f, 0.9176f, 0.6f);
        boolean hasTetrachromat = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ANEnchantments.TETRACHROMAT.get()), (LivingEntity)player) > 0;
        for (BlockPos pos : targetBlocksPos) {
            Color color = hasTetrachromat ? TetrachromatEnchantement.getColorForBlock(player.m_9236_().m_8055_(pos).m_60734_()) : defaultColor;
            AABB boundingBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0).m_82400_(0.05);
            FossilHighlightRenderer.drawBox(poseStack, boundingBox, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        }
        GL11.glStencilMask((int)255);
        GL11.glStencilFunc((int)519, (int)0, (int)255);
        GL11.glDisable((int)2960);
        GL11.glClear((int)1024);
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    private static void drawBox(PoseStack poseStack, AABB box, float red, float green, float blue, float alpha) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float minX = (float)box.f_82288_;
        float minY = (float)box.f_82289_;
        float minZ = (float)box.f_82290_;
        float maxX = (float)box.f_82291_;
        float maxY = (float)box.f_82292_;
        float maxZ = (float)box.f_82293_;
        bufferBuilder.m_252986_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }
}

