/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.event.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.reaper.ancientnature.client.model.TriceratopSkullModel;
import net.reaper.ancientnature.client.model.animation.TriceratopsSkullAnimation;
import net.reaper.ancientnature.client.renderer.TriceratopsBlockRenderer;
import net.reaper.ancientnature.common.block.TriceratopsSkullBlock;
import net.reaper.ancientnature.common.block.TriceratopsSkullDummyBlock;
import net.reaper.ancientnature.common.block.blockentity.TriceratopsSkullBlockEntity;
import net.reaper.ancientnature.common.block.blockentity.TriceratopsSkullDummyBlockEntity;
import org.lwjgl.opengl.GL11;

public class TriceratopsSkullBlockHighlightRenderer {
    public static void renderBlockHighlight(RenderHighlightEvent.Block event) {
        BlockState blockState;
        BlockPos pos = event.getTarget().m_82425_();
        if (Minecraft.m_91087_().f_91073_ != null && ((blockState = Minecraft.m_91087_().f_91073_.m_8055_(pos)).m_60734_() instanceof TriceratopsSkullBlock || blockState.m_60734_() instanceof TriceratopsSkullDummyBlock)) {
            TriceratopsSkullBlockEntity skullEntity;
            TriceratopsSkullDummyBlockEntity dummyEntity;
            BlockPos controllerPos;
            BlockEntity blockEntity;
            event.setCanceled(true);
            TriceratopSkullModel model = TriceratopsBlockRenderer.getModel();
            if (model == null) {
                return;
            }
            BlockPos mainPos = pos;
            Direction facing = Direction.NORTH;
            boolean isOpen = false;
            boolean isOnFloor = false;
            boolean isOnWall = false;
            if (blockState.m_60734_() instanceof TriceratopsSkullBlock) {
                facing = ((Direction)blockState.m_61143_(TriceratopsSkullBlock.FACING)).m_122424_();
                blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
                if (blockEntity instanceof TriceratopsSkullBlockEntity) {
                    TriceratopsSkullBlockEntity skullEntity2 = (TriceratopsSkullBlockEntity)blockEntity;
                    isOpen = skullEntity2.isOpen();
                    isOnFloor = (Boolean)blockState.m_61143_((Property)TriceratopsSkullBlock.FLOOR);
                    isOnWall = (Boolean)blockState.m_61143_((Property)TriceratopsSkullBlock.WALL);
                }
            } else if (blockState.m_60734_() instanceof TriceratopsSkullDummyBlock && (blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos)) instanceof TriceratopsSkullDummyBlockEntity && (controllerPos = (dummyEntity = (TriceratopsSkullDummyBlockEntity)blockEntity).getControllerPos()) != null) {
                mainPos = controllerPos;
                BlockState controllerState = Minecraft.m_91087_().f_91073_.m_8055_(controllerPos);
                if (controllerState.m_60734_() instanceof TriceratopsSkullBlock) {
                    facing = ((Direction)controllerState.m_61143_(TriceratopsSkullBlock.FACING)).m_122424_();
                    BlockEntity controllerEntity = Minecraft.m_91087_().f_91073_.m_7702_(controllerPos);
                    if (controllerEntity instanceof TriceratopsSkullBlockEntity) {
                        skullEntity = (TriceratopsSkullBlockEntity)controllerEntity;
                        isOpen = skullEntity.isOpen();
                        isOnFloor = (Boolean)controllerState.m_61143_((Property)TriceratopsSkullBlock.FLOOR);
                        isOnWall = (Boolean)controllerState.m_61143_((Property)TriceratopsSkullBlock.WALL);
                    }
                }
            }
            model.resetToDefaultPose();
            AnimationDefinition animation = TriceratopsSkullBlockHighlightRenderer.getAnimationDefinition(isOpen, isOnFloor, isOnWall);
            model.applyStaticAnimation(animation);
            PoseStack poseStack = event.getPoseStack();
            Camera camera = event.getCamera();
            Vec3 cameraPos = camera.m_90583_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)mainPos.m_123341_() - cameraPos.f_82479_, (double)mainPos.m_123342_() - cameraPos.f_82480_, (double)mainPos.m_123343_() - cameraPos.f_82481_);
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(facing.m_122435_()));
            skullEntity = event.getMultiBufferSource();
            if (skullEntity instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)skullEntity;
                bufferSource.m_109911_();
            }
            GL11.glEnable((int)2960);
            GL11.glStencilOp((int)7680, (int)7680, (int)7681);
            GL11.glStencilFunc((int)519, (int)1, (int)255);
            GL11.glStencilMask((int)255);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            VertexConsumer stencilConsumer = event.getMultiBufferSource().m_6299_(RenderType.m_110451_());
            TriceratopsSkullBlockHighlightRenderer.drawPartNormal(model.head, poseStack, stencilConsumer);
            MultiBufferSource multiBufferSource = event.getMultiBufferSource();
            if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
                bufferSource.m_109911_();
            }
            GL11.glStencilFunc((int)517, (int)1, (int)255);
            GL11.glStencilMask((int)0);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.lineWidth((float)2.0f);
            VertexConsumer lineConsumer = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
            TriceratopsSkullBlockHighlightRenderer.drawPartOutlineLines(model.head, poseStack, lineConsumer);
            MultiBufferSource multiBufferSource2 = event.getMultiBufferSource();
            if (multiBufferSource2 instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource2;
                bufferSource.m_109911_();
            }
            RenderSystem.lineWidth((float)1.0f);
            GL11.glStencilMask((int)255);
            GL11.glStencilFunc((int)519, (int)0, (int)255);
            GL11.glDisable((int)2960);
            GL11.glClear((int)1024);
            poseStack.m_85849_();
        }
    }

    private static AnimationDefinition getAnimationDefinition(boolean isOpen, boolean isOnFloor, boolean isOnWall) {
        AnimationDefinition animation = isOpen && isOnFloor ? TriceratopsSkullAnimation.FLOOR_OPEN : (isOpen && isOnWall ? TriceratopsSkullAnimation.WALL_OPEN : (isOpen ? TriceratopsSkullAnimation.NO_FLOOR_OPEN : (isOnWall ? TriceratopsSkullAnimation.WALL : TriceratopsSkullAnimation.FLOOR)));
        return animation;
    }

    private static void drawPartOutlineLines(ModelPart part, PoseStack poseStack, VertexConsumer consumer) {
        poseStack.m_85836_();
        part.m_104299_(poseStack);
        for (ModelPart.Cube cube : part.f_104212_) {
            TriceratopsSkullBlockHighlightRenderer.renderCubeEdges(cube, poseStack, consumer);
        }
        for (ModelPart child : part.f_104213_.values()) {
            TriceratopsSkullBlockHighlightRenderer.drawPartOutlineLines(child, poseStack, consumer);
        }
        poseStack.m_85849_();
    }

    private static void renderCubeEdges(ModelPart.Cube cube, PoseStack poseStack, VertexConsumer consumer) {
        PoseStack.Pose pose = poseStack.m_85850_();
        for (ModelPart.Polygon polygon : cube.f_104341_) {
            ModelPart.Vertex[] vertices = polygon.f_104359_;
            for (int i = 0; i < vertices.length; ++i) {
                ModelPart.Vertex v1 = vertices[i];
                ModelPart.Vertex v2 = vertices[(i + 1) % vertices.length];
                consumer.m_252986_(pose.m_252922_(), v1.f_104371_.x() / 16.0f, v1.f_104371_.y() / 16.0f, v1.f_104371_.z() / 16.0f).m_6122_(0, 0, 0, 255).m_252939_(pose.m_252943_(), polygon.f_104360_.x(), polygon.f_104360_.y(), polygon.f_104360_.z()).m_5752_();
                consumer.m_252986_(pose.m_252922_(), v2.f_104371_.x() / 16.0f, v2.f_104371_.y() / 16.0f, v2.f_104371_.z() / 16.0f).m_6122_(0, 0, 0, 255).m_252939_(pose.m_252943_(), polygon.f_104360_.x(), polygon.f_104360_.y(), polygon.f_104360_.z()).m_5752_();
            }
        }
    }

    private static void drawPartNormal(ModelPart part, PoseStack poseStack, VertexConsumer consumer) {
        poseStack.m_85836_();
        part.m_104299_(poseStack);
        for (ModelPart.Cube cube : part.f_104212_) {
            TriceratopsSkullBlockHighlightRenderer.renderNormalCube(cube, poseStack, consumer);
        }
        for (ModelPart child : part.f_104213_.values()) {
            TriceratopsSkullBlockHighlightRenderer.drawPartNormal(child, poseStack, consumer);
        }
        poseStack.m_85849_();
    }

    private static void renderNormalCube(ModelPart.Cube cube, PoseStack poseStack, VertexConsumer consumer) {
        PoseStack.Pose pose = poseStack.m_85850_();
        for (ModelPart.Polygon polygon : cube.f_104341_) {
            ModelPart.Vertex[] vertices;
            for (ModelPart.Vertex vertex : vertices = polygon.f_104359_) {
                consumer.m_252986_(pose.m_252922_(), vertex.f_104371_.x() / 16.0f, vertex.f_104371_.y() / 16.0f, vertex.f_104371_.z() / 16.0f).m_6122_(255, 255, 255, 255).m_7421_(vertex.f_104372_, vertex.f_104373_).m_7122_(0, 10).m_7120_(240, 240).m_252939_(pose.m_252943_(), polygon.f_104360_.x(), polygon.f_104360_.y(), polygon.f_104360_.z()).m_5752_();
            }
        }
    }
}

