/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.enums.Gender;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class NameTagSkins {
    public static final NameTagSkins INSTANCE = new NameTagSkins();
    private final Map<EntityType<?>, List<Entry<?>>> entries = new HashMap();
    private final List<String> ids = new ArrayList<String>();

    private NameTagSkins() {
    }

    @SafeVarargs
    @NotNull
    public final <T extends BaseAnimal<T>> NameTagSkins register(@NotNull EntityType<T> type, String id, ResourceLocation texture, Predicate<T> ... conditions) {
        this.entries.computeIfAbsent(type, t -> new ArrayList()).add(new Entry<T>(texture, Arrays.asList(conditions)));
        this.ids.add(id);
        return this;
    }

    @SafeVarargs
    @NotNull
    public final <T extends BaseAnimal<T>> NameTagSkins register(@NotNull EntityType<T> type, String id, ResourceLocation texture, @NotNull Collection<String> names, Predicate<T> ... conditions) {
        for (String name : names) {
            this.entries.computeIfAbsent(type, t -> new ArrayList()).add(new Entry(texture, List.of(Conditions.name(name)), Arrays.asList(conditions)));
            this.ids.add(id);
        }
        return this;
    }

    @Nullable
    public <T extends BaseAnimal<T>> ResourceLocation getTexture(@Nullable T mob) {
        List<Entry<?>> entries;
        Component name;
        if (mob != null && (name = mob.m_7770_()) != null && (entries = this.entries.get(mob.m_6095_())) != null) {
            return entries.stream().map(entry -> entry).filter(entry -> entry.conditions.stream().allMatch(cond -> cond.test(mob))).map(Entry::getTexture).findFirst().orElse(null);
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public @UnmodifiableView List<String> getIds() {
        return Collections.unmodifiableList(this.ids);
    }

    private static class Entry<T extends BaseAnimal<T>> {
        private final ResourceLocation texture;
        private final List<Predicate<T>> conditions;

        public Entry(@NotNull ResourceLocation texture, @NotNull List<Predicate<T>> base, @NotNull List<Predicate<T>> extra) {
            ArrayList<Predicate<T>> merged = new ArrayList<Predicate<T>>(base);
            merged.addAll(extra);
            this.texture = texture;
            this.conditions = merged;
        }

        public Entry(@NotNull ResourceLocation texture, @NotNull List<Predicate<T>> conditions) {
            this.texture = texture;
            this.conditions = conditions;
        }

        @NotNull
        public ResourceLocation getTexture() {
            return this.texture;
        }
    }

    public static final class Conditions {
        private Conditions() {
        }

        @Contract(pure=true)
        @NotNull
        public static <T extends BaseAnimal<T>> Predicate<T> name(final String name) {
            return new Predicate<T>(){

                @Override
                public boolean test(@NotNull T animal) {
                    Component cust = animal.m_7770_();
                    if (cust != null && animal.m_8077_()) {
                        return cust.getString().equalsIgnoreCase(name);
                    }
                    return false;
                }
            };
        }

        @Contract(pure=true)
        @NotNull
        public static <T extends BaseAnimal<T>> Predicate<T> anyName(final String ... names) {
            return new Predicate<T>(){

                @Override
                public boolean test(@NotNull T animal) {
                    Component cust = animal.m_7770_();
                    if (cust != null && animal.m_8077_()) {
                        for (String name : names) {
                            if (!cust.getString().equalsIgnoreCase(name)) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
        }

        @Contract(pure=true)
        @NotNull
        public static <T extends BaseAnimal<T>> Predicate<T> gender(Gender gender) {
            return animal -> animal.getGender() == gender;
        }

        @Contract(pure=true)
        @NotNull
        public static <T extends BaseAnimal<T>> Predicate<T> baby() {
            return LivingEntity::m_6162_;
        }

        @Contract(pure=true)
        @NotNull
        public static <T extends BaseAnimal<T>> Predicate<T> adult() {
            return animal -> !animal.m_6162_();
        }
    }
}

